//-----------------------------------------------------------------------------
//  File: RTC6impl.h
//-----------------------------------------------------------------------------
//
//  Abstract
//      RTC6 function prototypes for implicitly linking - also known as
//      static load linking - to the RTC6DLL.DLL or libslrtc6.so.
//
//      This file was automatically generated on 2025-10-24
//
//  NOTE
//      On Windows platforms for building an executable, you must link with 
//      the (Visual C++) import library RTC6DLL.LIB.
//
//-----------------------------------------------------------------------------

#pragma once

#if defined(__cplusplus)
extern "C" {
#endif //defined(__cplusplus)

#ifdef _WIN32
    #include <windows.h>
    #if !defined(ULONG_PTR)         //  usually defined in <BaseTsd.h>
        #if !defined(_WIN64)
            #define ULONG_PTR UINT
        #else
            #define ULONG_PTR UINT64
        #endif // !defined(_WIN64)
    #endif // !defined(ULONG_PTR)
#else
    #include <stdint.h>
    typedef int32_t LONG;     //  LONG  is assumed to be 4 Bytes
    typedef uint32_t UINT;     //  UINT  is assumed to be 4 Bytes
    typedef uint64_t UINT64;
    typedef uintptr_t ULONG_PTR;
    #define __stdcall
#endif

#include <stdbool.h>

#ifdef _WIN32
    #define RTC6_API __declspec(dllimport)
#else
    #define RTC6_API
#endif

RTC6_API UINT __stdcall init_rtc6_dll(void);
RTC6_API void __stdcall free_rtc6_dll(void);
RTC6_API void __stdcall set_rtc4_mode(void);
RTC6_API void __stdcall set_rtc5_mode(void);
RTC6_API void __stdcall set_rtc6_mode(void);
RTC6_API UINT __stdcall get_rtc_mode(void);
RTC6_API UINT __stdcall n_get_error(const UINT CardNo);
RTC6_API UINT __stdcall n_get_last_error(const UINT CardNo);
RTC6_API void __stdcall n_reset_error(const UINT CardNo, const UINT Code);
RTC6_API UINT __stdcall n_set_verify(const UINT CardNo, const UINT Verify);
RTC6_API UINT __stdcall get_error(void);
RTC6_API UINT __stdcall get_last_error(void);
RTC6_API void __stdcall reset_error(const UINT Code);
RTC6_API UINT __stdcall set_verify(const UINT Verify);
RTC6_API UINT __stdcall verify_checksum(const char* Name);
RTC6_API UINT __stdcall eth_count_cards(void);
RTC6_API UINT __stdcall eth_found_cards(void);
RTC6_API UINT __stdcall eth_max_card(void);
RTC6_API LONG __stdcall eth_remove_card(const UINT CardNo);
RTC6_API void __stdcall eth_get_card_info(const UINT CardNo, const ULONG_PTR Ptr);
RTC6_API void __stdcall eth_get_card_info_search(const UINT SearchNo, const ULONG_PTR Ptr);
RTC6_API void __stdcall eth_set_search_cards_timeout(const UINT TimeOut);
RTC6_API UINT __stdcall eth_search_cards(const UINT Ip, const UINT NetMask);
RTC6_API UINT __stdcall eth_search_cards_range(const UINT StartIp, const UINT EndIp);
RTC6_API LONG __stdcall eth_assign_card_ip(const UINT Ip, const UINT CardNo);
RTC6_API LONG __stdcall eth_assign_card(const UINT SearchNo, const UINT CardNo);
RTC6_API UINT __stdcall eth_convert_string_to_ip(const char* IpString);
RTC6_API void __stdcall eth_convert_ip_to_string(const UINT Ip, const ULONG_PTR IpString);
RTC6_API UINT __stdcall eth_get_ip(const UINT CardNo);
RTC6_API UINT __stdcall eth_get_ip_search(const UINT SearchNo);
RTC6_API UINT __stdcall eth_get_serial_search(const UINT SearchNo);
RTC6_API UINT __stdcall eth_full_reset(const UINT CardNo);
RTC6_API UINT __stdcall n_eth_get_last_error(const UINT CardNo);
RTC6_API UINT __stdcall n_eth_get_error(const UINT CardNo);
RTC6_API UINT __stdcall n_eth_error_dump(const UINT CardNo, const ULONG_PTR Dump);
RTC6_API UINT __stdcall n_eth_set_static_ip(const UINT CardNo, const UINT Ip, const UINT NetMask, const UINT Gateway);
RTC6_API UINT __stdcall n_eth_get_static_ip(const UINT CardNo, UINT* Ip, UINT* NetMask, UINT* Gateway);
RTC6_API UINT __stdcall n_eth_set_port_numbers(const UINT CardNo, const UINT UDPsearch, const UINT UDPexcl, const UINT TCP);
RTC6_API UINT __stdcall n_eth_get_port_numbers(const UINT CardNo, UINT* UDPsearch, UINT* UDPexcl, UINT* TCP);
RTC6_API void __stdcall n_eth_set_com_timeouts(const UINT CardNo, const UINT AcquireTimeout, const UINT AcquireMaxRetries, const UINT SendRecvTimeout, const UINT SendRecvMaxRetries, const UINT KeepAlive, const UINT KeepInterval);
RTC6_API void __stdcall n_eth_get_com_timeouts(const UINT CardNo, UINT* AcquireTimeout, UINT* AcquireMaxRetries, UINT* SendRecvTimeout, UINT* SendRecvMaxRetries, UINT* KeepAlive, UINT* KeepInterval);
RTC6_API void __stdcall n_eth_set_com_timeouts_auto(const UINT CardNo, const double InitialTimeout, const double MaxTimeout, const double Multiplier, const UINT Mode);
RTC6_API void __stdcall n_eth_get_com_timeouts_auto(const UINT CardNo, double* InitialTimeout, double* MaxTimeout, double* Multiplier, UINT* Mode);
RTC6_API UINT __stdcall n_eth_set_high_performance_mode(const UINT CardNo, const UINT Mode);
RTC6_API UINT __stdcall n_eth_check_connection(const UINT CardNo);
RTC6_API void __stdcall n_set_eth_boot_control(const UINT CardNo, const UINT Ctrl);
RTC6_API void __stdcall n_eth_boot_timeout(const UINT CardNo, const UINT Timeout);
RTC6_API void __stdcall n_eth_set_remote_tgm_format(const UINT CardNo, const UINT Format);
RTC6_API void __stdcall n_eth_boot_dcmd(const UINT CardNo);
RTC6_API UINT __stdcall n_store_program(const UINT CardNo, const UINT Mode);
RTC6_API UINT __stdcall n_read_image_eth(const UINT CardNo, const char* Name);
RTC6_API UINT __stdcall n_write_image_eth(const UINT CardNo, const char* Name);
RTC6_API void __stdcall n_eth_configure_link_loss(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_eth_get_standalone_status(const UINT CardNo, UINT* Status, UINT* Error, UINT* Mode);
RTC6_API void __stdcall n_eth_config_waveform_streaming_ctrl(const UINT CardNo, const UINT Size, const UINT Flags);
RTC6_API UINT __stdcall eth_get_last_error(void);
RTC6_API UINT __stdcall eth_get_error(void);
RTC6_API UINT __stdcall eth_error_dump(const ULONG_PTR Dump);
RTC6_API UINT __stdcall eth_set_static_ip(const UINT Ip, const UINT NetMask, const UINT Gateway);
RTC6_API UINT __stdcall eth_get_static_ip(UINT* Ip, UINT* NetMask, UINT* Gateway);
RTC6_API UINT __stdcall eth_set_port_numbers(const UINT UDPsearch, const UINT UDPexcl, const UINT TCP);
RTC6_API UINT __stdcall eth_get_port_numbers(UINT* UDPsearch, UINT* UDPexcl, UINT* TCP);
RTC6_API void __stdcall eth_set_com_timeouts(const UINT AcquireTimeout, const UINT AcquireMaxRetries, const UINT SendRecvTimeout, const UINT SendRecvMaxRetries, const UINT KeepAlive, const UINT KeepInterval);
RTC6_API void __stdcall eth_get_com_timeouts(UINT* AcquireTimeout, UINT* AcquireMaxRetries, UINT* SendRecvTimeout, UINT* SendRecvMaxRetries, UINT* KeepAlive, UINT* KeepInterval);
RTC6_API void __stdcall eth_set_com_timeouts_auto(const double InitialTimeout, const double MaxTimeout, const double Multiplier, const UINT Mode);
RTC6_API void __stdcall eth_get_com_timeouts_auto(double* InitialTimeout, double* MaxTimeout, double* Multiplier, UINT* Mode);
RTC6_API UINT __stdcall eth_set_high_performance_mode(const UINT Mode);
RTC6_API UINT __stdcall eth_check_connection(void);
RTC6_API void __stdcall set_eth_boot_control(const UINT Ctrl);
RTC6_API void __stdcall eth_boot_timeout(const UINT Timeout);
RTC6_API void __stdcall eth_set_remote_tgm_format(const UINT Format);
RTC6_API void __stdcall eth_boot_dcmd(void);
RTC6_API UINT __stdcall store_program(const UINT Mode);
RTC6_API UINT __stdcall read_image_eth(const char* Name);
RTC6_API UINT __stdcall write_image_eth(const char* Name);
RTC6_API void __stdcall eth_configure_link_loss(const UINT Mode);
RTC6_API void __stdcall eth_get_standalone_status(UINT* Status, UINT* Error, UINT* Mode);
RTC6_API void __stdcall eth_config_waveform_streaming_ctrl(const UINT Size, const UINT Flags);
RTC6_API UINT __stdcall read_abc_from_file(const char* Name, double* A, double* B, double* C);
RTC6_API UINT __stdcall write_abc_to_file(const char* Name, const double A, const double B, const double C);
RTC6_API UINT __stdcall read_abc_from_file_20b(const char* Name, double* A, double* B, double* C);
RTC6_API UINT __stdcall write_abc_to_file_20b(const char* Name, const double A, const double B, const double C);
RTC6_API UINT __stdcall n_create_dat_file(const UINT CardNo, const LONG Flag);
RTC6_API UINT __stdcall create_dat_file(const LONG Flag);
RTC6_API UINT __stdcall n_upgrade_bios(const UINT CardNo, const char* Name);
RTC6_API UINT __stdcall upgrade_bios(const char* Name);
RTC6_API UINT __stdcall transform(LONG* Sig1, LONG* Sig2, const ULONG_PTR Ptr, const UINT Code);
RTC6_API UINT __stdcall demux_rcm_ctrl(const ULONG_PTR Input, const UINT Input_length, const UINT N_signals, const UINT Index, const UINT Flags, ULONG_PTR Output);
RTC6_API UINT __stdcall rtc6_count_cards(void);
RTC6_API UINT __stdcall acquire_rtc(const UINT CardNo);
RTC6_API UINT __stdcall release_rtc(const UINT CardNo);
RTC6_API UINT __stdcall select_rtc(const UINT CardNo);
RTC6_API UINT __stdcall get_dll_version(void);
RTC6_API UINT __stdcall n_get_card_type(const UINT CardNo);
RTC6_API UINT __stdcall n_get_serial_number(const UINT CardNo);
RTC6_API UINT __stdcall n_get_hex_version(const UINT CardNo);
RTC6_API UINT __stdcall n_get_rtc_version(const UINT CardNo);
RTC6_API UINT __stdcall n_get_bios_version(const UINT CardNo);
RTC6_API UINT __stdcall get_card_type(void);
RTC6_API UINT __stdcall get_serial_number(void);
RTC6_API UINT __stdcall get_hex_version(void);
RTC6_API UINT __stdcall get_rtc_version(void);
RTC6_API UINT __stdcall get_bios_version(void);
RTC6_API UINT __stdcall n_load_program_file(const UINT CardNo, const char* Path);
RTC6_API void __stdcall n_sync_slaves(const UINT CardNo);
RTC6_API UINT __stdcall n_get_sync_status(const UINT CardNo);
RTC6_API void __stdcall n_master_slave_config(const UINT CardNo, const UINT Flags);
RTC6_API void __stdcall n_master_slave_set_offset_ctrl(const UINT CardNo, const UINT Mode, const UINT Ctrl);
RTC6_API UINT __stdcall n_load_correction_file(const UINT CardNo, const char* Name, const UINT No, const UINT Dim);
RTC6_API UINT __stdcall n_load_zoom_correction_file(const UINT CardNo, const char* Name, const UINT No);
RTC6_API UINT __stdcall n_load_oct_table_no(const UINT CardNo, const double A, const double B, const UINT No);
RTC6_API UINT __stdcall n_load_z_table_no(const UINT CardNo, const double A, const double B, const double C, const UINT No);
RTC6_API UINT __stdcall n_load_z_table(const UINT CardNo, const double A, const double B, const double C);
RTC6_API void __stdcall n_select_cor_table(const UINT CardNo, const UINT HeadA, const UINT HeadB);
RTC6_API UINT __stdcall n_set_dsp_mode(const UINT CardNo, const UINT Mode);
RTC6_API LONG __stdcall n_load_stretch_table(const UINT CardNo, const char* Name, const LONG No, const UINT TableNo);
RTC6_API void __stdcall n_number_of_correction_tables(const UINT CardNo, const UINT Number);
RTC6_API UINT __stdcall n_load_z_table_no_20b(const UINT CardNo, const double A, const double B, const double C, const UINT No);
RTC6_API UINT __stdcall n_load_z_table_20b(const UINT CardNo, const double A, const double B, const double C);
RTC6_API double __stdcall n_get_head_para(const UINT CardNo, const UINT HeadNo, const UINT ParaNo);
RTC6_API double __stdcall n_get_table_para(const UINT CardNo, const UINT TableNo, const UINT ParaNo);
RTC6_API UINT __stdcall load_program_file(const char* Path);
RTC6_API void __stdcall sync_slaves(void);
RTC6_API UINT __stdcall get_sync_status(void);
RTC6_API void __stdcall master_slave_config(const UINT Flags);
RTC6_API void __stdcall master_slave_set_offset_ctrl(const UINT Mode, const UINT Ctrl);
RTC6_API UINT __stdcall load_correction_file(const char* Name, const UINT No, const UINT Dim);
RTC6_API UINT __stdcall load_zoom_correction_file(const char* Name, const UINT No);
RTC6_API UINT __stdcall load_oct_table_no(const double A, const double B, const UINT No);
RTC6_API UINT __stdcall load_z_table_no(const double A, const double B, const double C, const UINT No);
RTC6_API UINT __stdcall load_z_table(const double A, const double B, const double C);
RTC6_API void __stdcall select_cor_table(const UINT HeadA, const UINT HeadB);
RTC6_API UINT __stdcall set_dsp_mode(const UINT Mode);
RTC6_API LONG __stdcall load_stretch_table(const char* Name, const LONG No, const UINT TableNo);
RTC6_API void __stdcall number_of_correction_tables(const UINT Number);
RTC6_API UINT __stdcall load_z_table_no_20b(const double A, const double B, const double C, const UINT No);
RTC6_API UINT __stdcall load_z_table_20b(const double A, const double B, const double C);
RTC6_API double __stdcall get_head_para(const UINT HeadNo, const UINT ParaNo);
RTC6_API double __stdcall get_table_para(const UINT TableNo, const UINT ParaNo);
RTC6_API void __stdcall n_config_list(const UINT CardNo, const UINT Mem1, const UINT Mem2);
RTC6_API void __stdcall n_get_config_list(const UINT CardNo);
RTC6_API UINT __stdcall n_save_disk(const UINT CardNo, const char* Name, const UINT Mode);
RTC6_API UINT __stdcall n_load_disk(const UINT CardNo, const char* Name, const UINT Mode);
RTC6_API UINT __stdcall n_get_list_space(const UINT CardNo);
RTC6_API void __stdcall config_list(const UINT Mem1, const UINT Mem2);
RTC6_API void __stdcall get_config_list(void);
RTC6_API UINT __stdcall save_disk(const char* Name, const UINT Mode);
RTC6_API UINT __stdcall load_disk(const char* Name, const UINT Mode);
RTC6_API UINT __stdcall get_list_space(void);
RTC6_API void __stdcall n_set_start_list_pos(const UINT CardNo, const UINT ListNo, const UINT Pos);
RTC6_API void __stdcall n_set_start_list(const UINT CardNo, const UINT ListNo);
RTC6_API void __stdcall n_set_start_list_1(const UINT CardNo);
RTC6_API void __stdcall n_set_start_list_2(const UINT CardNo);
RTC6_API void __stdcall n_set_input_pointer(const UINT CardNo, const UINT Pos);
RTC6_API UINT __stdcall n_load_list(const UINT CardNo, const UINT ListNo, const UINT Pos);
RTC6_API void __stdcall n_load_sub(const UINT CardNo, const UINT Index);
RTC6_API void __stdcall n_load_char(const UINT CardNo, const UINT Char);
RTC6_API void __stdcall n_load_text_table(const UINT CardNo, const UINT Index);
RTC6_API void __stdcall n_get_list_pointer(const UINT CardNo, UINT* ListNo, UINT* Pos);
RTC6_API UINT __stdcall n_get_input_pointer(const UINT CardNo);
RTC6_API void __stdcall set_start_list_pos(const UINT ListNo, const UINT Pos);
RTC6_API void __stdcall set_start_list(const UINT ListNo);
RTC6_API void __stdcall set_start_list_1(void);
RTC6_API void __stdcall set_start_list_2(void);
RTC6_API void __stdcall set_input_pointer(const UINT Pos);
RTC6_API UINT __stdcall load_list(const UINT ListNo, const UINT Pos);
RTC6_API void __stdcall load_sub(const UINT Index);
RTC6_API void __stdcall load_char(const UINT Char);
RTC6_API void __stdcall load_text_table(const UINT Index);
RTC6_API void __stdcall get_list_pointer(UINT* ListNo, UINT* Pos);
RTC6_API UINT __stdcall get_input_pointer(void);
RTC6_API void __stdcall n_execute_list_pos(const UINT CardNo, const UINT ListNo, const UINT Pos);
RTC6_API void __stdcall n_execute_at_pointer(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_execute_list(const UINT CardNo, const UINT ListNo);
RTC6_API void __stdcall n_execute_list_1(const UINT CardNo);
RTC6_API void __stdcall n_execute_list_2(const UINT CardNo);
RTC6_API UINT __stdcall n_list_jump_rel_ctrl(const UINT CardNo, const LONG Pos);
RTC6_API void __stdcall n_get_out_pointer(const UINT CardNo, UINT* ListNo, UINT* Pos);
RTC6_API void __stdcall execute_list_pos(const UINT ListNo, const UINT Pos);
RTC6_API void __stdcall execute_at_pointer(const UINT Pos);
RTC6_API void __stdcall execute_list(const UINT ListNo);
RTC6_API void __stdcall execute_list_1(void);
RTC6_API void __stdcall execute_list_2(void);
RTC6_API UINT __stdcall list_jump_rel_ctrl(const LONG Pos);
RTC6_API void __stdcall get_out_pointer(UINT* ListNo, UINT* Pos);
RTC6_API void __stdcall n_auto_change_pos(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_start_loop(const UINT CardNo);
RTC6_API void __stdcall n_quit_loop(const UINT CardNo);
RTC6_API void __stdcall n_pause_list(const UINT CardNo);
RTC6_API void __stdcall n_restart_list(const UINT CardNo);
RTC6_API void __stdcall n_release_wait(const UINT CardNo);
RTC6_API void __stdcall n_stop_execution(const UINT CardNo);
RTC6_API void __stdcall n_set_pause_list_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall n_set_pause_list_not_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall n_auto_change(const UINT CardNo);
RTC6_API void __stdcall n_stop_list(const UINT CardNo);
RTC6_API UINT __stdcall n_get_wait_status(const UINT CardNo);
RTC6_API UINT __stdcall n_read_status(const UINT CardNo);
RTC6_API void __stdcall n_get_status(const UINT CardNo, UINT* Status, UINT* Pos);
RTC6_API void __stdcall n_set_short_cmd_mode_ctrl(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall auto_change_pos(const UINT Pos);
RTC6_API void __stdcall start_loop(void);
RTC6_API void __stdcall quit_loop(void);
RTC6_API void __stdcall pause_list(void);
RTC6_API void __stdcall restart_list(void);
RTC6_API void __stdcall release_wait(void);
RTC6_API void __stdcall stop_execution(void);
RTC6_API void __stdcall set_pause_list_cond(const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall set_pause_list_not_cond(const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall auto_change(void);
RTC6_API void __stdcall stop_list(void);
RTC6_API UINT __stdcall get_wait_status(void);
RTC6_API UINT __stdcall read_status(void);
RTC6_API void __stdcall get_status(UINT* Status, UINT* Pos);
RTC6_API void __stdcall set_short_cmd_mode_ctrl(const UINT Mode);
RTC6_API void __stdcall n_set_extstartpos(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_set_max_counts(const UINT CardNo, const UINT Counts);
RTC6_API void __stdcall n_set_control_mode(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_simulate_ext_stop(const UINT CardNo);
RTC6_API void __stdcall n_simulate_ext_start_ctrl(const UINT CardNo);
RTC6_API void __stdcall n_store_timestamp_counter(const UINT CardNo);
RTC6_API void __stdcall n_get_timestamp_long(const UINT CardNo, UINT* TimeStampL, UINT* TimeStampH);
RTC6_API UINT __stdcall n_get_counts(const UINT CardNo);
RTC6_API UINT __stdcall n_get_startstop_info(const UINT CardNo);
RTC6_API void __stdcall set_extstartpos(const UINT Pos);
RTC6_API void __stdcall set_max_counts(const UINT Counts);
RTC6_API void __stdcall set_control_mode(const UINT Mode);
RTC6_API void __stdcall simulate_ext_stop(void);
RTC6_API void __stdcall simulate_ext_start_ctrl(void);
RTC6_API void __stdcall store_timestamp_counter(void);
RTC6_API void __stdcall get_timestamp_long(UINT* TimeStampL, UINT* TimeStampH);
RTC6_API UINT __stdcall get_counts(void);
RTC6_API UINT __stdcall get_startstop_info(void);
RTC6_API void __stdcall n_copy_dst_src(const UINT CardNo, const UINT Dst, const UINT Src, const UINT Mode);
RTC6_API void __stdcall n_set_char_pointer(const UINT CardNo, const UINT Char, const UINT Pos);
RTC6_API void __stdcall n_set_sub_pointer(const UINT CardNo, const UINT Index, const UINT Pos);
RTC6_API void __stdcall n_set_text_table_pointer(const UINT CardNo, const UINT Index, const UINT Pos);
RTC6_API void __stdcall n_set_char_table(const UINT CardNo, const UINT Index, const UINT Pos);
RTC6_API UINT __stdcall n_get_char_pointer(const UINT CardNo, const UINT Char);
RTC6_API UINT __stdcall n_get_sub_pointer(const UINT CardNo, const UINT Index);
RTC6_API UINT __stdcall n_get_text_table_pointer(const UINT CardNo, const UINT Index);
RTC6_API void __stdcall copy_dst_src(const UINT Dst, const UINT Src, const UINT Mode);
RTC6_API void __stdcall set_char_pointer(const UINT Char, const UINT Pos);
RTC6_API void __stdcall set_sub_pointer(const UINT Index, const UINT Pos);
RTC6_API void __stdcall set_text_table_pointer(const UINT Index, const UINT Pos);
RTC6_API void __stdcall set_char_table(const UINT Index, const UINT Pos);
RTC6_API UINT __stdcall get_char_pointer(const UINT Char);
RTC6_API UINT __stdcall get_sub_pointer(const UINT Index);
RTC6_API UINT __stdcall get_text_table_pointer(const UINT Index);
RTC6_API void __stdcall n_time_update(const UINT CardNo);
RTC6_API void __stdcall n_time_control_eth(const UINT CardNo, const double PPM);
RTC6_API void __stdcall n_set_serial_step(const UINT CardNo, const UINT No, const UINT Step);
RTC6_API void __stdcall n_select_serial_set(const UINT CardNo, const UINT No);
RTC6_API void __stdcall n_set_serial(const UINT CardNo, const UINT No);
RTC6_API double __stdcall n_get_serial(const UINT CardNo);
RTC6_API double __stdcall n_get_list_serial(const UINT CardNo, UINT* SetNo);
RTC6_API void __stdcall time_update(void);
RTC6_API void __stdcall time_control_eth(const double PPM);
RTC6_API void __stdcall set_serial_step(const UINT No, const UINT Step);
RTC6_API void __stdcall select_serial_set(const UINT No);
RTC6_API void __stdcall set_serial(const UINT No);
RTC6_API double __stdcall get_serial(void);
RTC6_API double __stdcall get_list_serial(UINT* SetNo);
RTC6_API void __stdcall n_write_io_port_mask(const UINT CardNo, const UINT Value, const UINT Mask);
RTC6_API void __stdcall n_write_8bit_port(const UINT CardNo, const UINT Value);
RTC6_API UINT __stdcall n_read_io_port(const UINT CardNo);
RTC6_API UINT __stdcall n_read_io_port_buffer(const UINT CardNo, const UINT Index, UINT* Value, LONG* XPos, LONG* YPos, UINT* Time);
RTC6_API UINT __stdcall n_get_io_status(const UINT CardNo);
RTC6_API UINT __stdcall n_read_analog_in(const UINT CardNo);
RTC6_API void __stdcall n_write_da_x(const UINT CardNo, const UINT x, const UINT Value);
RTC6_API void __stdcall n_set_laser_off_default(const UINT CardNo, const UINT AnalogOut1, const UINT AnalogOut2, const UINT DigitalOut);
RTC6_API void __stdcall n_set_port_default(const UINT CardNo, const UINT Port, const UINT Value);
RTC6_API void __stdcall n_write_io_port(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall n_write_da_1(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall n_write_da_2(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall write_io_port_mask(const UINT Value, const UINT Mask);
RTC6_API void __stdcall write_8bit_port(const UINT Value);
RTC6_API UINT __stdcall read_io_port(void);
RTC6_API UINT __stdcall read_io_port_buffer(const UINT Index, UINT* Value, LONG* XPos, LONG* YPos, UINT* Time);
RTC6_API UINT __stdcall get_io_status(void);
RTC6_API UINT __stdcall read_analog_in(void);
RTC6_API void __stdcall write_da_x(const UINT x, const UINT Value);
RTC6_API void __stdcall set_laser_off_default(const UINT AnalogOut1, const UINT AnalogOut2, const UINT DigitalOut);
RTC6_API void __stdcall set_port_default(const UINT Port, const UINT Value);
RTC6_API void __stdcall write_io_port(const UINT Value);
RTC6_API void __stdcall write_da_1(const UINT Value);
RTC6_API void __stdcall write_da_2(const UINT Value);
RTC6_API void __stdcall n_disable_laser(const UINT CardNo);
RTC6_API void __stdcall n_enable_laser(const UINT CardNo);
RTC6_API void __stdcall n_laser_signal_on(const UINT CardNo);
RTC6_API void __stdcall n_laser_signal_off(const UINT CardNo);
RTC6_API void __stdcall n_set_standby(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall n_set_laser_pulses_ctrl(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall n_set_firstpulse_killer(const UINT CardNo, const UINT Length);
RTC6_API void __stdcall n_set_qswitch_delay(const UINT CardNo, const UINT Delay);
RTC6_API void __stdcall n_set_laser_mode(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_set_laser_control(const UINT CardNo, const UINT Ctrl);
RTC6_API void __stdcall n_set_laser_pin_out(const UINT CardNo, const UINT Pins);
RTC6_API UINT __stdcall n_get_laser_pin_in(const UINT CardNo);
RTC6_API void __stdcall n_set_softstart_level(const UINT CardNo, const UINT Index, const UINT Level);
RTC6_API void __stdcall n_set_softstart_mode(const UINT CardNo, const UINT Mode, const UINT Number, const UINT Delay);
RTC6_API UINT __stdcall n_set_auto_laser_control(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT Mode, const UINT MinValue, const UINT MaxValue);
RTC6_API UINT __stdcall n_set_auto_laser_params(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
RTC6_API LONG __stdcall n_load_auto_laser_control(const UINT CardNo, const char* Name, const UINT No);
RTC6_API LONG __stdcall n_load_position_control(const UINT CardNo, const char* Name, const UINT No);
RTC6_API UINT __stdcall n_load_position_control_2d_ctrl(const UINT CardNo, const char* Name);
RTC6_API void __stdcall n_set_default_pixel(const UINT CardNo, const UINT PulseLength);
RTC6_API void __stdcall n_get_standby(const UINT CardNo, UINT* HalfPeriod, UINT* PulseLength);
RTC6_API void __stdcall n_set_pulse_picking(const UINT CardNo, const UINT No);
RTC6_API void __stdcall n_set_pulse_picking_length(const UINT CardNo, const UINT Length);
RTC6_API void __stdcall n_config_laser_signals(const UINT CardNo, const UINT Config);
RTC6_API void __stdcall n_spot_distance_ctrl(const UINT CardNo, const double Dist);
RTC6_API void __stdcall n_set_laser_pulse_form(const UINT CardNo, const UINT Mode, const UINT Length);
RTC6_API void __stdcall n_set_laser_pulse_sync(const UINT CardNo, const UINT Mode, const UINT Delay);
RTC6_API void __stdcall n_set_controlpreview_compensation_ctrl(const UINT CardNo, const UINT ControlPreview, const UINT Mode);
RTC6_API void __stdcall n_set_laser_delays_ctrl(const UINT CardNo, const LONG LaserOnDelay, const UINT LaserOffDelay);
RTC6_API void __stdcall disable_laser(void);
RTC6_API void __stdcall enable_laser(void);
RTC6_API void __stdcall laser_signal_on(void);
RTC6_API void __stdcall laser_signal_off(void);
RTC6_API void __stdcall set_standby(const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall set_laser_pulses_ctrl(const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall set_firstpulse_killer(const UINT Length);
RTC6_API void __stdcall set_qswitch_delay(const UINT Delay);
RTC6_API void __stdcall set_laser_mode(const UINT Mode);
RTC6_API void __stdcall set_laser_control(const UINT Ctrl);
RTC6_API void __stdcall set_laser_pin_out(const UINT Pins);
RTC6_API UINT __stdcall get_laser_pin_in(void);
RTC6_API void __stdcall set_softstart_level(const UINT Index, const UINT Level);
RTC6_API void __stdcall set_softstart_mode(const UINT Mode, const UINT Number, const UINT Delay);
RTC6_API UINT __stdcall set_auto_laser_control(const UINT Ctrl, const UINT Value, const UINT Mode, const UINT MinValue, const UINT MaxValue);
RTC6_API UINT __stdcall set_auto_laser_params(const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
RTC6_API LONG __stdcall load_auto_laser_control(const char* Name, const UINT No);
RTC6_API LONG __stdcall load_position_control(const char* Name, const UINT No);
RTC6_API UINT __stdcall load_position_control_2d_ctrl(const char* Name);
RTC6_API void __stdcall set_default_pixel(const UINT PulseLength);
RTC6_API void __stdcall get_standby(UINT* HalfPeriod, UINT* PulseLength);
RTC6_API void __stdcall set_pulse_picking(const UINT No);
RTC6_API void __stdcall set_pulse_picking_length(const UINT Length);
RTC6_API void __stdcall config_laser_signals(const UINT Config);
RTC6_API void __stdcall spot_distance_ctrl(const double Dist);
RTC6_API void __stdcall set_laser_pulse_form(const UINT Mode, const UINT Length);
RTC6_API void __stdcall set_laser_pulse_sync(const UINT Mode, const UINT Delay);
RTC6_API void __stdcall set_controlpreview_compensation_ctrl(const UINT ControlPreview, const UINT Mode);
RTC6_API void __stdcall set_laser_delays_ctrl(const LONG LaserOnDelay, const UINT LaserOffDelay);
RTC6_API void __stdcall n_set_ext_start_delay(const UINT CardNo, const LONG Delay, const UINT EncoderNo);
RTC6_API void __stdcall n_set_rot_center(const UINT CardNo, const LONG X, const LONG Y);
RTC6_API void __stdcall n_simulate_encoder(const UINT CardNo, const UINT EncoderNo);
RTC6_API UINT __stdcall n_get_marking_info(const UINT CardNo);
RTC6_API void __stdcall n_set_encoder_speed_ctrl(const UINT CardNo, const UINT EncoderNo, const double Speed, const double Smooth);
RTC6_API void __stdcall n_set_mcbsp_x(const UINT CardNo, const double ScaleX);
RTC6_API void __stdcall n_set_mcbsp_y(const UINT CardNo, const double ScaleY);
RTC6_API void __stdcall n_set_mcbsp_rot(const UINT CardNo, const double Resolution);
RTC6_API void __stdcall n_set_mcbsp_matrix(const UINT CardNo);
RTC6_API void __stdcall n_set_mcbsp_global_x(const UINT CardNo, const double ScaleX);
RTC6_API void __stdcall n_set_mcbsp_global_y(const UINT CardNo, const double ScaleY);
RTC6_API void __stdcall n_set_mcbsp_global_rot(const UINT CardNo, const double Resolution);
RTC6_API void __stdcall n_set_mcbsp_global_matrix(const UINT CardNo);
RTC6_API void __stdcall n_set_mcbsp_in(const UINT CardNo, const UINT Mode, const double Scale);
RTC6_API void __stdcall n_set_multi_mcbsp_in(const UINT CardNo, const UINT Ctrl, const UINT P, const UINT Mode);
RTC6_API void __stdcall n_set_fly_tracking_error(const UINT CardNo, const UINT TrackingErrorX, const UINT TrackingErrorY);
RTC6_API LONG __stdcall n_load_fly_2d_table(const UINT CardNo, const char* Name, const UINT No);
RTC6_API void __stdcall n_init_fly_2d(const UINT CardNo, const LONG OffsetX, const LONG OffsetY, const UINT No);
RTC6_API void __stdcall n_get_fly_2d_offset(const UINT CardNo, LONG* OffsetX, LONG* OffsetY);
RTC6_API void __stdcall n_get_encoder(const UINT CardNo, LONG* Encoder0, LONG* Encoder1);
RTC6_API void __stdcall n_read_encoder(const UINT CardNo, LONG* Encoder0_1, LONG* Encoder1_1, LONG* Encoder0_2, LONG* Encoder1_2);
RTC6_API LONG __stdcall n_get_mcbsp(const UINT CardNo);
RTC6_API LONG __stdcall n_read_mcbsp(const UINT CardNo, const UINT No);
RTC6_API LONG __stdcall n_read_multi_mcbsp(const UINT CardNo, const UINT No);
RTC6_API void __stdcall n_clear_fly_overflow_ctrl(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_set_encoder_filter_ctrl(const UINT CardNo, const UINT Length, const UINT Mode);
RTC6_API void __stdcall set_ext_start_delay(const LONG Delay, const UINT EncoderNo);
RTC6_API void __stdcall set_rot_center(const LONG X, const LONG Y);
RTC6_API void __stdcall simulate_encoder(const UINT EncoderNo);
RTC6_API UINT __stdcall get_marking_info(void);
RTC6_API void __stdcall set_encoder_speed_ctrl(const UINT EncoderNo, const double Speed, const double Smooth);
RTC6_API void __stdcall set_mcbsp_x(const double ScaleX);
RTC6_API void __stdcall set_mcbsp_y(const double ScaleY);
RTC6_API void __stdcall set_mcbsp_rot(const double Resolution);
RTC6_API void __stdcall set_mcbsp_matrix(void);
RTC6_API void __stdcall set_mcbsp_global_x(const double ScaleX);
RTC6_API void __stdcall set_mcbsp_global_y(const double ScaleY);
RTC6_API void __stdcall set_mcbsp_global_rot(const double Resolution);
RTC6_API void __stdcall set_mcbsp_global_matrix(void);
RTC6_API void __stdcall set_mcbsp_in(const UINT Mode, const double Scale);
RTC6_API void __stdcall set_multi_mcbsp_in(const UINT Ctrl, const UINT P, const UINT Mode);
RTC6_API void __stdcall set_fly_tracking_error(const UINT TrackingErrorX, const UINT TrackingErrorY);
RTC6_API LONG __stdcall load_fly_2d_table(const char* Name, const UINT No);
RTC6_API void __stdcall init_fly_2d(const LONG OffsetX, const LONG OffsetY, const UINT No);
RTC6_API void __stdcall get_fly_2d_offset(LONG* OffsetX, LONG* OffsetY);
RTC6_API void __stdcall get_encoder(LONG* Encoder0, LONG* Encoder1);
RTC6_API void __stdcall read_encoder(LONG* Encoder0_1, LONG* Encoder1_1, LONG* Encoder0_2, LONG* Encoder1_2);
RTC6_API LONG __stdcall get_mcbsp(void);
RTC6_API LONG __stdcall read_mcbsp(const UINT No);
RTC6_API LONG __stdcall read_multi_mcbsp(const UINT No);
RTC6_API void __stdcall clear_fly_overflow_ctrl(const UINT Mode);
RTC6_API void __stdcall set_encoder_filter_ctrl(const UINT Length, const UINT Mode);
RTC6_API double __stdcall n_get_time(const UINT CardNo);
RTC6_API double __stdcall n_get_lap_time(const UINT CardNo);
RTC6_API void __stdcall n_measurement_status(const UINT CardNo, UINT* Busy, UINT* Pos);
RTC6_API void __stdcall n_get_waveform_offset(const UINT CardNo, const UINT Channel, const UINT Offset, const UINT Number, const ULONG_PTR Ptr);
RTC6_API void __stdcall n_get_waveform(const UINT CardNo, const UINT Channel, const UINT Number, const ULONG_PTR Ptr);
RTC6_API void __stdcall n_bounce_supp(const UINT CardNo, const UINT Length);
RTC6_API void __stdcall n_home_position_4(const UINT CardNo, const LONG X0Home, const LONG X1Home, const LONG X2Home, const LONG X3Home);
RTC6_API void __stdcall n_get_home_position_4(const UINT CardNo, LONG* X0Home, LONG* X1Home, LONG* X2Home, LONG* X3Home);
RTC6_API void __stdcall n_set_home_4_return_time(const UINT CardNo, const UINT Time);
RTC6_API UINT __stdcall n_get_home_4_return_time(const UINT CardNo);
RTC6_API void __stdcall n_home_position_xyz(const UINT CardNo, const LONG XHome, const LONG YHome, const LONG ZHome);
RTC6_API void __stdcall n_home_position(const UINT CardNo, const LONG XHome, const LONG YHome);
RTC6_API UINT __stdcall n_uart_config(const UINT CardNo, const UINT BaudRate);
RTC6_API void __stdcall n_rs232_config(const UINT CardNo, const UINT BaudRate);
RTC6_API void __stdcall n_rs232_write_data(const UINT CardNo, const UINT Data);
RTC6_API void __stdcall n_rs232_write_text(const UINT CardNo, const char* pData);
RTC6_API UINT __stdcall n_rs232_read_data(const UINT CardNo);
RTC6_API UINT __stdcall n_set_mcbsp_freq(const UINT CardNo, const UINT Freq);
RTC6_API void __stdcall n_mcbsp_init(const UINT CardNo, const UINT XDelay, const UINT RDelay);
RTC6_API void __stdcall n_mcbsp_init_spi(const UINT CardNo, const UINT ClockLevel, const UINT ClockDelay);
RTC6_API UINT __stdcall n_get_overrun(const UINT CardNo);
RTC6_API UINT __stdcall n_get_master_slave(const UINT CardNo);
RTC6_API void __stdcall n_get_transform(const UINT CardNo, const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
RTC6_API void __stdcall n_get_transform_offset(const UINT CardNo, const UINT Channel1, const UINT Channel2, const UINT Offset, const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
RTC6_API void __stdcall n_stop_trigger(const UINT CardNo);
RTC6_API void __stdcall n_move_to(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_set_enduring_wobbel(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall n_set_enduring_wobbel_2(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall n_set_enduring_wobbel_3(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall n_set_enduring_wobbel_4(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall n_set_enduring_wobbel_ctrl(const UINT CardNo, const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ, const UINT Mode, const UINT Ctrl);
RTC6_API UINT __stdcall n_check_enduring_wobbel(const UINT CardNo);
RTC6_API void __stdcall n_set_free_variable(const UINT CardNo, const UINT VarNo, const UINT Value);
RTC6_API UINT __stdcall n_get_free_variable(const UINT CardNo, const UINT VarNo);
RTC6_API void __stdcall n_set_mcbsp_out_ptr(const UINT CardNo, const UINT Number, const ULONG_PTR SignalPtr);
RTC6_API void __stdcall n_set_mcbsp_out_oie_ctrl(const UINT CardNo, const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall n_periodic_toggle(const UINT CardNo, const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
RTC6_API UINT __stdcall n_multi_axis_set_config_ctrl(const UINT CardNo, const UINT Mode, const UINT BlockSize, const UINT NumAxes, const UINT StopOnFrameError, const UINT StopOnStageError);
RTC6_API void __stdcall n_multi_axis_get_config_ctrl(const UINT CardNo, UINT* Mode, UINT* BlockSize, UINT* NumAxes, UINT* StopOnFrameError, UINT* StopOnStageError);
RTC6_API UINT __stdcall n_multi_axis_get_error_ctrl(const UINT CardNo);
RTC6_API UINT __stdcall n_multi_axis_init_ctrl(const UINT CardNo, const ULONG_PTR StageAxesPtr);
RTC6_API void __stdcall n_multi_axis_get_values_ctrl(const UINT CardNo, const ULONG_PTR StageAxesPtr, const ULONG_PTR FlagsPtr);
RTC6_API double __stdcall n_get_temperature(const UINT CardNo);
RTC6_API UINT __stdcall n_get_extended_head_status_value_ctrl(const UINT CardNo, const UINT Head, const UINT Axis, const UINT Value);
RTC6_API void __stdcall n_get_extended_head_status_block_ctrl(const UINT CardNo, const UINT Head, const UINT Axis, const ULONG_PTR Ptr);
RTC6_API UINT __stdcall n_get_rcm_value_ctrl(const UINT CardNo, const UINT Head, const UINT Axis, const UINT Value);
RTC6_API void __stdcall n_marking_info_ack_ctrl(const UINT CardNo, const UINT AckMask);
RTC6_API void __stdcall n_set_sl2_100_error_tolerance_ctrl(const UINT CardNo, const UINT Tol_10us);
RTC6_API UINT __stdcall n_get_sl2_100_error_tolerance_ctrl(const UINT CardNo);
RTC6_API void __stdcall n_set_sl2_100_error_tolerance_enable_ctrl(const UINT CardNo, const bool Enable);
RTC6_API bool __stdcall n_get_sl2_100_error_tolerance_enable_ctrl(const UINT CardNo);
RTC6_API void __stdcall n_set_explicit_ack_mode_ctrl(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_startstop_info_ack_ctrl(const UINT CardNo, const UINT AckMask);
RTC6_API double __stdcall get_time(void);
RTC6_API double __stdcall get_lap_time(void);
RTC6_API void __stdcall measurement_status(UINT* Busy, UINT* Pos);
RTC6_API void __stdcall get_waveform_offset(const UINT Channel, const UINT Offset, const UINT Number, const ULONG_PTR Ptr);
RTC6_API void __stdcall get_waveform(const UINT Channel, const UINT Number, const ULONG_PTR Ptr);
RTC6_API void __stdcall bounce_supp(const UINT Length);
RTC6_API void __stdcall home_position_4(const LONG X0Home, const LONG X1Home, const LONG X2Home, const LONG X3Home);
RTC6_API void __stdcall get_home_position_4(LONG* X0Home, LONG* X1Home, LONG* X2Home, LONG* X3Home);
RTC6_API void __stdcall set_home_4_return_time(const UINT Time);
RTC6_API UINT __stdcall get_home_4_return_time(void);
RTC6_API void __stdcall home_position_xyz(const LONG XHome, const LONG YHome, const LONG ZHome);
RTC6_API void __stdcall home_position(const LONG XHome, const LONG YHome);
RTC6_API UINT __stdcall uart_config(const UINT BaudRate);
RTC6_API void __stdcall rs232_config(const UINT BaudRate);
RTC6_API void __stdcall rs232_write_data(const UINT Data);
RTC6_API void __stdcall rs232_write_text(const char* pData);
RTC6_API UINT __stdcall rs232_read_data(void);
RTC6_API UINT __stdcall set_mcbsp_freq(const UINT Freq);
RTC6_API void __stdcall mcbsp_init(const UINT XDelay, const UINT RDelay);
RTC6_API void __stdcall mcbsp_init_spi(const UINT ClockLevel, const UINT ClockDelay);
RTC6_API UINT __stdcall get_overrun(void);
RTC6_API UINT __stdcall get_master_slave(void);
RTC6_API void __stdcall get_transform(const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
RTC6_API void __stdcall get_transform_offset(const UINT Channel1, const UINT Channel2, const UINT Offset, const UINT Number, const ULONG_PTR Ptr1, const ULONG_PTR Ptr2, const ULONG_PTR Ptr, const UINT Code);
RTC6_API void __stdcall stop_trigger(void);
RTC6_API void __stdcall move_to(const UINT Pos);
RTC6_API void __stdcall set_enduring_wobbel(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall set_enduring_wobbel_2(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall set_enduring_wobbel_3(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall set_enduring_wobbel_4(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ);
RTC6_API void __stdcall set_enduring_wobbel_ctrl(const UINT CenterX, const UINT CenterY, const UINT CenterZ, const UINT LimitHi, const UINT LimitLo, const double ScaleX, const double ScaleY, const double ScaleZ, const UINT Mode, const UINT Ctrl);
RTC6_API UINT __stdcall check_enduring_wobbel(void);
RTC6_API void __stdcall set_free_variable(const UINT VarNo, const UINT Value);
RTC6_API UINT __stdcall get_free_variable(const UINT VarNo);
RTC6_API void __stdcall set_mcbsp_out_ptr(const UINT Number, const ULONG_PTR SignalPtr);
RTC6_API void __stdcall set_mcbsp_out_oie_ctrl(const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall periodic_toggle(const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
RTC6_API UINT __stdcall multi_axis_set_config_ctrl(const UINT Mode, const UINT BlockSize, const UINT NumAxes, const UINT StopOnFrameError, const UINT StopOnStageError);
RTC6_API void __stdcall multi_axis_get_config_ctrl(UINT* Mode, UINT* BlockSize, UINT* NumAxes, UINT* StopOnFrameError, UINT* StopOnStageError);
RTC6_API UINT __stdcall multi_axis_get_error_ctrl(void);
RTC6_API UINT __stdcall multi_axis_init_ctrl(const ULONG_PTR StageAxesPtr);
RTC6_API void __stdcall multi_axis_get_values_ctrl(const ULONG_PTR StageAxesPtr, const ULONG_PTR FlagsPtr);
RTC6_API double __stdcall get_temperature(void);
RTC6_API UINT __stdcall get_extended_head_status_value_ctrl(const UINT Head, const UINT Axis, const UINT Value);
RTC6_API void __stdcall get_extended_head_status_block_ctrl(const UINT Head, const UINT Axis, const ULONG_PTR Ptr);
RTC6_API UINT __stdcall get_rcm_value_ctrl(const UINT Head, const UINT Axis, const UINT Value);
RTC6_API void __stdcall marking_info_ack_ctrl(const UINT AckMask);
RTC6_API void __stdcall set_sl2_100_error_tolerance_ctrl(const UINT Tol_10us);
RTC6_API UINT __stdcall get_sl2_100_error_tolerance_ctrl(void);
RTC6_API void __stdcall set_sl2_100_error_tolerance_enable_ctrl(const bool Enable);
RTC6_API bool __stdcall get_sl2_100_error_tolerance_enable_ctrl(void);
RTC6_API void __stdcall set_explicit_ack_mode_ctrl(const UINT Mode);
RTC6_API void __stdcall startstop_info_ack_ctrl(const UINT AckMask);
RTC6_API void __stdcall n_set_defocus(const UINT CardNo, const LONG Shift);
RTC6_API void __stdcall n_set_defocus_offset(const UINT CardNo, const LONG Shift);
RTC6_API void __stdcall n_goto_xyz(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall n_set_zoom(const UINT CardNo, const UINT Zoom);
RTC6_API void __stdcall n_goto_xy(const UINT CardNo, const LONG X, const LONG Y);
RTC6_API LONG __stdcall n_get_z_distance(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall set_defocus(const LONG Shift);
RTC6_API void __stdcall set_defocus_offset(const LONG Shift);
RTC6_API void __stdcall goto_xyz(const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall goto_xy(const LONG X, const LONG Y);
RTC6_API void __stdcall set_zoom(const UINT Zoom);
RTC6_API LONG __stdcall get_z_distance(const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall n_set_offset_xyz(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
RTC6_API void __stdcall n_set_offset(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
RTC6_API void __stdcall n_set_matrix(const UINT CardNo, const UINT HeadNo, const double M11, const double M12, const double M21, const double M22, const UINT at_once);
RTC6_API void __stdcall n_set_angle(const UINT CardNo, const UINT HeadNo, const double Angle, const UINT at_once);
RTC6_API void __stdcall n_set_scale(const UINT CardNo, const UINT HeadNo, const double Scale, const UINT at_once);
RTC6_API void __stdcall n_apply_mcbsp(const UINT CardNo, const UINT HeadNo, const UINT at_once);
RTC6_API UINT __stdcall n_upload_transform(const UINT CardNo, const UINT HeadNo, const ULONG_PTR Ptr);
RTC6_API void __stdcall set_offset_xyz(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
RTC6_API void __stdcall set_offset(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
RTC6_API void __stdcall set_matrix(const UINT HeadNo, const double M11, const double M12, const double M21, const double M22, const UINT at_once);
RTC6_API void __stdcall set_angle(const UINT HeadNo, const double Angle, const UINT at_once);
RTC6_API void __stdcall set_scale(const UINT HeadNo, const double Scale, const UINT at_once);
RTC6_API void __stdcall apply_mcbsp(const UINT HeadNo, const UINT at_once);
RTC6_API UINT __stdcall upload_transform(const UINT HeadNo, const ULONG_PTR Ptr);
RTC6_API void __stdcall n_set_delay_mode(const UINT CardNo, const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
RTC6_API void __stdcall n_set_jump_speed_ctrl(const UINT CardNo, const double Speed);
RTC6_API void __stdcall n_set_mark_speed_ctrl(const UINT CardNo, const double Speed);
RTC6_API void __stdcall n_set_sky_writing_para(const UINT CardNo, const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
RTC6_API void __stdcall n_set_sky_writing_limit(const UINT CardNo, const double CosAngle);
RTC6_API void __stdcall n_set_sky_writing_mode(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_set_sky_writing_min_speed_ctrl(const UINT CardNo, const double Speed);
RTC6_API void __stdcall n_set_sky_writing_scale_ctrl(const UINT CardNo, const double Scale);
RTC6_API LONG __stdcall n_load_varpolydelay(const UINT CardNo, const char* Name, const UINT No);
RTC6_API void __stdcall n_set_hi(const UINT CardNo, const UINT HeadNo, const double GalvoGainX, const double GalvoGainY, const LONG GalvoOffsetX, const LONG GalvoOffsetY);
RTC6_API void __stdcall n_get_hi_pos(const UINT CardNo, const UINT HeadNo, LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
RTC6_API UINT __stdcall n_auto_cal(const UINT CardNo, const UINT HeadNo, const UINT Command);
RTC6_API UINT __stdcall n_get_auto_cal(const UINT CardNo, const UINT HeadNo);
RTC6_API UINT __stdcall n_write_hi_pos(const UINT CardNo, const UINT HeadNo, const LONG X1, const LONG X2, const LONG Y1, const LONG Y2);
RTC6_API void __stdcall n_set_timelag_compensation(const UINT CardNo, const UINT HeadNo, const UINT TimeLagXY, const UINT TimeLagZ);
RTC6_API void __stdcall n_set_scanner_delays_ctrl(const UINT CardNo, const UINT Jump, const UINT Mark, const UINT Polygon);
RTC6_API void __stdcall n_set_sky_writing(const UINT CardNo, const double Timelag, const LONG LaserOnShift);
RTC6_API void __stdcall n_get_hi_data(const UINT CardNo, LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
RTC6_API void __stdcall set_delay_mode(const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
RTC6_API void __stdcall set_jump_speed_ctrl(const double Speed);
RTC6_API void __stdcall set_mark_speed_ctrl(const double Speed);
RTC6_API void __stdcall set_sky_writing_para(const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
RTC6_API void __stdcall set_sky_writing_limit(const double CosAngle);
RTC6_API void __stdcall set_sky_writing_mode(const UINT Mode);
RTC6_API void __stdcall set_sky_writing_min_speed_ctrl(const double Speed);
RTC6_API void __stdcall set_sky_writing_scale_ctrl(const double Scale);
RTC6_API LONG __stdcall load_varpolydelay(const char* Name, const UINT No);
RTC6_API void __stdcall set_hi(const UINT HeadNo, const double GalvoGainX, const double GalvoGainY, const LONG GalvoOffsetX, const LONG GalvoOffsetY);
RTC6_API void __stdcall get_hi_pos(const UINT HeadNo, LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
RTC6_API UINT __stdcall auto_cal(const UINT HeadNo, const UINT Command);
RTC6_API UINT __stdcall get_auto_cal(const UINT HeadNo);
RTC6_API UINT __stdcall write_hi_pos(const UINT HeadNo, const LONG X1, const LONG X2, const LONG Y1, const LONG Y2);
RTC6_API void __stdcall set_timelag_compensation(const UINT HeadNo, const UINT TimeLagXY, const UINT TimeLagZ);
RTC6_API void __stdcall set_scanner_delays_ctrl(const UINT Jump, const UINT Mark, const UINT Polygon);
RTC6_API void __stdcall set_sky_writing(const double Timelag, const LONG LaserOnShift);
RTC6_API void __stdcall get_hi_data(LONG* X1, LONG* X2, LONG* Y1, LONG* Y2);
RTC6_API void __stdcall n_send_user_data(const UINT CardNo, const UINT Head, const UINT Axis, const LONG Data0, const LONG Data1, const LONG Data2, const LONG Data3, const LONG Data4);
RTC6_API LONG __stdcall n_read_user_data(const UINT CardNo, const UINT Head, const UINT Axis, LONG* Data0, LONG* Data1, LONG* Data2, LONG* Data3, LONG* Data4);
RTC6_API void __stdcall n_control_command(const UINT CardNo, const UINT Head, const UINT Axis, const UINT Data);
RTC6_API LONG __stdcall n_get_value(const UINT CardNo, const UINT Signal);
RTC6_API void __stdcall n_get_values(const UINT CardNo, const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
RTC6_API void __stdcall n_get_galvo_controls(const UINT CardNo, const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
RTC6_API UINT __stdcall n_get_head_status(const UINT CardNo, const UINT Head);
RTC6_API LONG __stdcall n_set_jump_mode(const UINT CardNo, const LONG Flag, const UINT Length, const LONG VA1, const LONG VA2, const LONG VB1, const LONG VB2, const LONG JA1, const LONG JA2, const LONG JB1, const LONG JB2);
RTC6_API LONG __stdcall n_load_jump_table_offset(const UINT CardNo, const char* Name, const UINT No, const UINT PosAck, const LONG Offset, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
RTC6_API UINT __stdcall n_get_jump_table(const UINT CardNo, const ULONG_PTR Ptr);
RTC6_API UINT __stdcall n_set_jump_table(const UINT CardNo, const ULONG_PTR Ptr);
RTC6_API LONG __stdcall n_load_jump_table(const UINT CardNo, const char* Name, const UINT No, const UINT PosAck, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
RTC6_API void __stdcall send_user_data(const UINT Head, const UINT Axis, const LONG Data0, const LONG Data1, const LONG Data2, const LONG Data3, const LONG Data4);
RTC6_API LONG __stdcall read_user_data(const UINT Head, const UINT Axis, LONG* Data0, LONG* Data1, LONG* Data2, LONG* Data3, LONG* Data4);
RTC6_API void __stdcall control_command(const UINT Head, const UINT Axis, const UINT Data);
RTC6_API LONG __stdcall get_value(const UINT Signal);
RTC6_API void __stdcall get_values(const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
RTC6_API void __stdcall get_galvo_controls(const ULONG_PTR SignalPtr, const ULONG_PTR ResultPtr);
RTC6_API UINT __stdcall get_head_status(const UINT Head);
RTC6_API LONG __stdcall set_jump_mode(const LONG Flag, const UINT Length, const LONG VA1, const LONG VA2, const LONG VB1, const LONG VB2, const LONG JA1, const LONG JA2, const LONG JB1, const LONG JB2);
RTC6_API LONG __stdcall load_jump_table_offset(const char* Name, const UINT No, const UINT PosAck, const LONG Offset, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
RTC6_API UINT __stdcall get_jump_table(const ULONG_PTR Ptr);
RTC6_API UINT __stdcall set_jump_table(const ULONG_PTR Ptr);
RTC6_API LONG __stdcall load_jump_table(const char* Name, const UINT No, const UINT PosAck, const UINT MinDelay, const UINT MaxDelay, const UINT ListPos);
RTC6_API UINT __stdcall n_get_scanahead_params(const UINT CardNo, const UINT HeadNo, UINT* PreViewTime, UINT* Vmax, double* Amax);
RTC6_API LONG __stdcall n_activate_scanahead_autodelays(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_set_scanahead_laser_shifts(const UINT CardNo, const LONG dLasOn, const LONG dLasOff);
RTC6_API void __stdcall n_set_scanahead_line_params(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale);
RTC6_API void __stdcall n_set_scanahead_line_params_ex(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
RTC6_API UINT __stdcall n_set_scanahead_params(const UINT CardNo, const UINT Mode, const UINT HeadNo, const UINT TableNo, const UINT PreViewTime, const UINT Vmax, const double Amax);
RTC6_API void __stdcall n_set_scanahead_speed_control(const UINT CardNo, const UINT Mode);
RTC6_API UINT __stdcall get_scanahead_params(const UINT HeadNo, UINT* PreViewTime, UINT* Vmax, double* Amax);
RTC6_API LONG __stdcall activate_scanahead_autodelays(const LONG Mode);
RTC6_API void __stdcall set_scanahead_laser_shifts(const LONG dLasOn, const LONG dLasOff);
RTC6_API void __stdcall set_scanahead_line_params(const UINT CornerScale, const UINT EndScale, const UINT AccScale);
RTC6_API void __stdcall set_scanahead_line_params_ex(const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
RTC6_API UINT __stdcall set_scanahead_params(const UINT Mode, const UINT HeadNo, const UINT TableNo, const UINT PreViewTime, const UINT Vmax, const double Amax);
RTC6_API void __stdcall set_scanahead_speed_control(const UINT Mode);
RTC6_API void __stdcall n_stepper_init(const UINT CardNo, const UINT No, const UINT Period, const LONG Dir, const LONG Pos, const UINT Tol, const UINT Enable, const UINT WaitTime);
RTC6_API void __stdcall n_stepper_enable(const UINT CardNo, const LONG Enable1, const LONG Enable2);
RTC6_API void __stdcall n_stepper_disable_switch(const UINT CardNo, const LONG Disable1, const LONG Disable2);
RTC6_API void __stdcall n_stepper_control(const UINT CardNo, const LONG Period1, const LONG Period2);
RTC6_API void __stdcall n_stepper_abs_no(const UINT CardNo, const UINT No, const LONG Pos, const UINT WaitTime);
RTC6_API void __stdcall n_stepper_rel_no(const UINT CardNo, const UINT No, const LONG dPos, const UINT WaitTime);
RTC6_API void __stdcall n_stepper_abs(const UINT CardNo, const LONG Pos1, const LONG Pos2, const UINT WaitTime);
RTC6_API void __stdcall n_stepper_rel(const UINT CardNo, const LONG dPos1, const LONG dPos2, const UINT WaitTime);
RTC6_API void __stdcall n_get_stepper_status(const UINT CardNo, UINT* Status1, LONG* Pos1, UINT* Status2, LONG* Pos2);
RTC6_API void __stdcall stepper_init(const UINT No, const UINT Period, const LONG Dir, const LONG Pos, const UINT Tol, const UINT Enable, const UINT WaitTime);
RTC6_API void __stdcall stepper_enable(const LONG Enable1, const LONG Enable2);
RTC6_API void __stdcall stepper_disable_switch(const LONG Disable1, const LONG Disable2);
RTC6_API void __stdcall stepper_control(const LONG Period1, const LONG Period2);
RTC6_API void __stdcall stepper_abs_no(const UINT No, const LONG Pos, const UINT WaitTime);
RTC6_API void __stdcall stepper_rel_no(const UINT No, const LONG dPos, const UINT WaitTime);
RTC6_API void __stdcall stepper_abs(const LONG Pos1, const LONG Pos2, const UINT WaitTime);
RTC6_API void __stdcall stepper_rel(const LONG dPos1, const LONG dPos2, const UINT WaitTime);
RTC6_API void __stdcall get_stepper_status(UINT* Status1, LONG* Pos1, UINT* Status2, LONG* Pos2);
RTC6_API void __stdcall n_select_cor_table_list(const UINT CardNo, const UINT HeadA, const UINT HeadB);
RTC6_API void __stdcall select_cor_table_list(const UINT HeadA, const UINT HeadB);
RTC6_API void __stdcall n_list_nop(const UINT CardNo);
RTC6_API void __stdcall n_list_continue(const UINT CardNo);
RTC6_API void __stdcall n_list_next(const UINT CardNo);
RTC6_API void __stdcall n_long_delay(const UINT CardNo, const UINT Delay);
RTC6_API void __stdcall n_set_end_of_list(const UINT CardNo);
RTC6_API void __stdcall n_set_wait(const UINT CardNo, const UINT WaitWord);
RTC6_API void __stdcall n_list_jump_pos(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_list_jump_rel(const UINT CardNo, const LONG Pos);
RTC6_API void __stdcall n_list_repeat(const UINT CardNo);
RTC6_API void __stdcall n_list_until(const UINT CardNo, const UINT Number);
RTC6_API void __stdcall n_range_checking(const UINT CardNo, const UINT HeadNo, const UINT Mode, const UINT Data);
RTC6_API void __stdcall n_store_timestamp_counter_list(const UINT CardNo);
RTC6_API void __stdcall n_wait_for_timestamp_counter(const UINT CardNo, const UINT TimeStampCounter);
RTC6_API void __stdcall n_wait_for_timestamp_counter_mode(const UINT CardNo, const UINT TimeStampCounter, const UINT Mode);
RTC6_API void __stdcall n_set_short_cmd_mode_list(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_set_list_jump(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_wait_for_timestamp_counter_long(const UINT CardNo, const UINT WaitCounterL, const UINT WaitCounterH, const UINT MaxWaitTime, const UINT Mode);
RTC6_API void __stdcall list_nop(void);
RTC6_API void __stdcall list_continue(void);
RTC6_API void __stdcall list_next(void);
RTC6_API void __stdcall long_delay(const UINT Delay);
RTC6_API void __stdcall set_end_of_list(void);
RTC6_API void __stdcall set_wait(const UINT WaitWord);
RTC6_API void __stdcall list_jump_pos(const UINT Pos);
RTC6_API void __stdcall list_jump_rel(const LONG Pos);
RTC6_API void __stdcall list_repeat(void);
RTC6_API void __stdcall list_until(const UINT Number);
RTC6_API void __stdcall range_checking(const UINT HeadNo, const UINT Mode, const UINT Data);
RTC6_API void __stdcall store_timestamp_counter_list(void);
RTC6_API void __stdcall wait_for_timestamp_counter(const UINT TimeStampCounter);
RTC6_API void __stdcall wait_for_timestamp_counter_mode(const UINT TimeStampCounter, const UINT Mode);
RTC6_API void __stdcall wait_for_timestamp_counter_long(const UINT WaitCounterL, const UINT WaitCounterH, const UINT MaxWaitTime, const UINT Mode);
RTC6_API void __stdcall set_short_cmd_mode_list(const UINT Mode);
RTC6_API void __stdcall set_list_jump(const UINT Pos);
RTC6_API void __stdcall n_set_extstartpos_list(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_set_control_mode_list(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_simulate_ext_start(const UINT CardNo, const LONG Delay, const UINT EncoderNo);
RTC6_API void __stdcall set_extstartpos_list(const UINT Pos);
RTC6_API void __stdcall set_control_mode_list(const UINT Mode);
RTC6_API void __stdcall simulate_ext_start(const LONG Delay, const UINT EncoderNo);
RTC6_API void __stdcall n_list_return(const UINT CardNo);
RTC6_API void __stdcall n_list_call_repeat(const UINT CardNo, const UINT Pos, const UINT Number);
RTC6_API void __stdcall n_list_call_abs_repeat(const UINT CardNo, const UINT Pos, const UINT Number);
RTC6_API void __stdcall n_list_call(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_list_call_abs(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_sub_call_repeat(const UINT CardNo, const UINT Index, const UINT Number);
RTC6_API void __stdcall n_sub_call_abs_repeat(const UINT CardNo, const UINT Index, const UINT Number);
RTC6_API void __stdcall n_sub_call(const UINT CardNo, const UINT Index);
RTC6_API void __stdcall n_sub_call_abs(const UINT CardNo, const UINT Index);
RTC6_API void __stdcall list_return(void);
RTC6_API void __stdcall list_call_repeat(const UINT Pos, const UINT Number);
RTC6_API void __stdcall list_call_abs_repeat(const UINT Pos, const UINT Number);
RTC6_API void __stdcall list_call(const UINT Pos);
RTC6_API void __stdcall list_call_abs(const UINT Pos);
RTC6_API void __stdcall sub_call_repeat(const UINT Index, const UINT Number);
RTC6_API void __stdcall sub_call_abs_repeat(const UINT Index, const UINT Number);
RTC6_API void __stdcall sub_call(const UINT Index);
RTC6_API void __stdcall sub_call_abs(const UINT Index);
RTC6_API void __stdcall n_list_call_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall n_list_call_abs_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall n_sub_call_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall n_sub_call_abs_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall n_list_jump_pos_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Index);
RTC6_API void __stdcall n_list_jump_rel_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const LONG Index);
RTC6_API void __stdcall n_if_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall n_if_not_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall n_if_pin_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall n_if_not_pin_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall n_switch_ioport(const UINT CardNo, const UINT MaskBits, const UINT ShiftBits);
RTC6_API void __stdcall n_list_jump_cond(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall list_call_cond(const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall list_call_abs_cond(const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall sub_call_cond(const UINT Mask1, const UINT Mask0, const UINT Index);
RTC6_API void __stdcall sub_call_abs_cond(const UINT Mask1, const UINT Mask0, const UINT Index);
RTC6_API void __stdcall list_jump_pos_cond(const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall list_jump_rel_cond(const UINT Mask1, const UINT Mask0, const LONG Pos);
RTC6_API void __stdcall if_cond(const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall if_not_cond(const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall if_pin_cond(const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall if_not_pin_cond(const UINT Mask1, const UINT Mask0);
RTC6_API void __stdcall switch_ioport(const UINT MaskBits, const UINT ShiftBits);
RTC6_API void __stdcall list_jump_cond(const UINT Mask1, const UINT Mask0, const UINT Pos);
RTC6_API void __stdcall n_select_char_set(const UINT CardNo, const UINT No);
RTC6_API void __stdcall n_mark_text(const UINT CardNo, const char* Text);
RTC6_API void __stdcall n_mark_text_abs(const UINT CardNo, const char* Text);
RTC6_API void __stdcall n_mark_char(const UINT CardNo, const UINT Char);
RTC6_API void __stdcall n_mark_char_abs(const UINT CardNo, const UINT Char);
RTC6_API void __stdcall select_char_set(const UINT No);
RTC6_API void __stdcall mark_text(const char* Text);
RTC6_API void __stdcall mark_text_abs(const char* Text);
RTC6_API void __stdcall mark_char(const UINT Char);
RTC6_API void __stdcall mark_char_abs(const UINT Char);
RTC6_API void __stdcall n_mark_serial(const UINT CardNo, const UINT Mode, const UINT Digits);
RTC6_API void __stdcall n_mark_serial_abs(const UINT CardNo, const UINT Mode, const UINT Digits);
RTC6_API void __stdcall n_mark_date(const UINT CardNo, const UINT Part, const UINT Mode);
RTC6_API void __stdcall n_mark_date_abs(const UINT CardNo, const UINT Part, const UINT Mode);
RTC6_API void __stdcall n_mark_time(const UINT CardNo, const UINT Part, const UINT Mode);
RTC6_API void __stdcall n_mark_time_abs(const UINT CardNo, const UINT Part, const UINT Mode);
RTC6_API void __stdcall n_select_serial_set_list(const UINT CardNo, const UINT No);
RTC6_API void __stdcall n_set_serial_step_list(const UINT CardNo, const UINT No, const UINT Step);
RTC6_API void __stdcall n_time_fix_f_off(const UINT CardNo, const UINT FirstDay, const UINT Offset);
RTC6_API void __stdcall n_time_fix_f(const UINT CardNo, const UINT FirstDay);
RTC6_API void __stdcall n_time_fix(const UINT CardNo);
RTC6_API void __stdcall mark_serial(const UINT Mode, const UINT Digits);
RTC6_API void __stdcall mark_serial_abs(const UINT Mode, const UINT Digits);
RTC6_API void __stdcall mark_date(const UINT Part, const UINT Mode);
RTC6_API void __stdcall mark_date_abs(const UINT Part, const UINT Mode);
RTC6_API void __stdcall mark_time(const UINT Part, const UINT Mode);
RTC6_API void __stdcall mark_time_abs(const UINT Part, const UINT Mode);
RTC6_API void __stdcall time_fix_f_off(const UINT FirstDay, const UINT Offset);
RTC6_API void __stdcall select_serial_set_list(const UINT No);
RTC6_API void __stdcall set_serial_step_list(const UINT No, const UINT Step);
RTC6_API void __stdcall time_fix_f(const UINT FirstDay);
RTC6_API void __stdcall time_fix(void);
RTC6_API void __stdcall n_clear_io_cond_list(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT MaskClear);
RTC6_API void __stdcall n_set_io_cond_list(const UINT CardNo, const UINT Mask1, const UINT Mask0, const UINT MaskSet);
RTC6_API void __stdcall n_write_io_port_mask_list(const UINT CardNo, const UINT Value, const UINT Mask);
RTC6_API void __stdcall n_write_io_port_mask_ex_list(const UINT CardNo, const UINT Value, const UINT Mask, const UINT NoDelay);
RTC6_API void __stdcall n_write_8bit_port_list(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall n_read_io_port_list(const UINT CardNo);
RTC6_API void __stdcall n_write_da_x_list(const UINT CardNo, const UINT x, const UINT Value);
RTC6_API void __stdcall n_write_io_port_list(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall n_write_da_1_list(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall n_write_da_2_list(const UINT CardNo, const UINT Value);
RTC6_API void __stdcall n_write_port_list(const UINT CardNo, const UINT Port, const UINT Value, const UINT NoDelay);
RTC6_API void __stdcall clear_io_cond_list(const UINT Mask1, const UINT Mask0, const UINT MaskClear);
RTC6_API void __stdcall set_io_cond_list(const UINT Mask1, const UINT Mask0, const UINT MaskSet);
RTC6_API void __stdcall write_io_port_mask_list(const UINT Value, const UINT Mask);
RTC6_API void __stdcall write_io_port_mask_ex_list(const UINT Value, const UINT Mask, const UINT NoDelay);
RTC6_API void __stdcall write_8bit_port_list(const UINT Value);
RTC6_API void __stdcall read_io_port_list(void);
RTC6_API void __stdcall write_da_x_list(const UINT x, const UINT Value);
RTC6_API void __stdcall write_io_port_list(const UINT Value);
RTC6_API void __stdcall write_da_1_list(const UINT Value);
RTC6_API void __stdcall write_da_2_list(const UINT Value);
RTC6_API void __stdcall write_port_list(const UINT Port, const UINT Value, const UINT NoDelay);
RTC6_API void __stdcall n_laser_signal_on_list(const UINT CardNo);
RTC6_API void __stdcall n_laser_signal_off_list(const UINT CardNo);
RTC6_API void __stdcall n_para_laser_on_pulses_list(const UINT CardNo, const UINT Period, const UINT Pulses, const UINT P);
RTC6_API void __stdcall n_laser_on_pulses_list(const UINT CardNo, const UINT Period, const UINT Pulses);
RTC6_API void __stdcall n_laser_on_list(const UINT CardNo, const UINT Period);
RTC6_API void __stdcall n_set_laser_delays(const UINT CardNo, const LONG LaserOnDelay, const UINT LaserOffDelay);
RTC6_API void __stdcall n_set_standby_list(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall n_set_laser_pulses(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall n_set_firstpulse_killer_list(const UINT CardNo, const UINT Length);
RTC6_API void __stdcall n_set_qswitch_delay_list(const UINT CardNo, const UINT Delay);
RTC6_API void __stdcall n_set_laser_pin_out_list(const UINT CardNo, const UINT Pins);
RTC6_API void __stdcall n_set_vector_control(const UINT CardNo, const UINT Ctrl, const UINT Value);
RTC6_API void __stdcall n_set_default_pixel_list(const UINT CardNo, const UINT PulseLength);
RTC6_API void __stdcall n_set_auto_laser_params_list(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
RTC6_API void __stdcall n_set_pulse_picking_list(const UINT CardNo, const UINT No);
RTC6_API void __stdcall n_set_softstart_level_list(const UINT CardNo, const UINT Index, const UINT Level1, const UINT Level2, const UINT Level3);
RTC6_API void __stdcall n_set_softstart_mode_list(const UINT CardNo, const UINT Mode, const UINT Number, const UINT Delay);
RTC6_API void __stdcall n_config_laser_signals_list(const UINT CardNo, const UINT Config);
RTC6_API void __stdcall n_set_laser_power(const UINT CardNo, const UINT Port, const UINT Value);
RTC6_API void __stdcall n_set_port_default_list(const UINT CardNo, const UINT Port, const UINT Value);
RTC6_API void __stdcall n_spot_distance(const UINT CardNo, const double Dist);
RTC6_API void __stdcall n_set_laser_timing(const UINT CardNo, const UINT HalfPeriod, const UINT PulseLength1, const UINT PulseLength2, const UINT TimeBase);
RTC6_API void __stdcall laser_signal_on_list(void);
RTC6_API void __stdcall laser_signal_off_list(void);
RTC6_API void __stdcall para_laser_on_pulses_list(const UINT Period, const UINT Pulses, const UINT P);
RTC6_API void __stdcall laser_on_pulses_list(const UINT Period, const UINT Pulses);
RTC6_API void __stdcall laser_on_list(const UINT Period);
RTC6_API void __stdcall set_laser_delays(const LONG LaserOnDelay, const UINT LaserOffDelay);
RTC6_API void __stdcall set_standby_list(const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall set_laser_pulses(const UINT HalfPeriod, const UINT PulseLength);
RTC6_API void __stdcall set_firstpulse_killer_list(const UINT Length);
RTC6_API void __stdcall set_qswitch_delay_list(const UINT Delay);
RTC6_API void __stdcall set_laser_pin_out_list(const UINT Pins);
RTC6_API void __stdcall set_vector_control(const UINT Ctrl, const UINT Value);
RTC6_API void __stdcall set_default_pixel_list(const UINT PulseLength);
RTC6_API void __stdcall set_auto_laser_params_list(const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
RTC6_API void __stdcall set_pulse_picking_list(const UINT No);
RTC6_API void __stdcall set_softstart_level_list(const UINT Index, const UINT Level1, const UINT Level2, const UINT Level3);
RTC6_API void __stdcall set_softstart_mode_list(const UINT Mode, const UINT Number, const UINT Delay);
RTC6_API void __stdcall config_laser_signals_list(const UINT Config);
RTC6_API void __stdcall set_laser_power(const UINT Port, const UINT Value);
RTC6_API void __stdcall set_port_default_list(const UINT Port, const UINT Value);
RTC6_API void __stdcall spot_distance(const double Dist);
RTC6_API void __stdcall set_laser_timing(const UINT HalfPeriod, const UINT PulseLength1, const UINT PulseLength2, const UINT TimeBase);
RTC6_API void __stdcall n_fly_return_z(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall n_fly_return(const UINT CardNo, const LONG X, const LONG Y);
RTC6_API void __stdcall n_set_rot_center_list(const UINT CardNo, const LONG X, const LONG Y);
RTC6_API void __stdcall n_set_ext_start_delay_list(const UINT CardNo, const LONG Delay, const UINT EncoderNo);
RTC6_API void __stdcall n_set_fly_x(const UINT CardNo, const double ScaleX);
RTC6_API void __stdcall n_set_fly_y(const UINT CardNo, const double ScaleY);
RTC6_API void __stdcall n_set_fly_z(const UINT CardNo, const double ScaleZ, const UINT EndoderNo);
RTC6_API void __stdcall n_set_fly_rot(const UINT CardNo, const double Resolution);
RTC6_API void __stdcall n_set_fly_2d(const UINT CardNo, const double ScaleX, const double ScaleY);
RTC6_API void __stdcall n_set_fly_x_pos(const UINT CardNo, const double ScaleX);
RTC6_API void __stdcall n_set_fly_y_pos(const UINT CardNo, const double ScaleY);
RTC6_API void __stdcall n_set_fly_rot_pos(const UINT CardNo, const double Resolution);
RTC6_API void __stdcall n_set_fly_limits(const UINT CardNo, const LONG Xmin, const LONG Xmax, const LONG Ymin, const LONG Ymax);
RTC6_API void __stdcall n_set_fly_limits_z(const UINT CardNo, const LONG Zmin, const LONG Zmax);
RTC6_API void __stdcall n_if_fly_x_overflow(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_if_fly_y_overflow(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_if_fly_z_overflow(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_if_not_fly_x_overflow(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_if_not_fly_y_overflow(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_if_not_fly_z_overflow(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_clear_fly_overflow(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_set_mcbsp_x_list(const UINT CardNo, const double ScaleX);
RTC6_API void __stdcall n_set_mcbsp_y_list(const UINT CardNo, const double ScaleY);
RTC6_API void __stdcall n_set_mcbsp_rot_list(const UINT CardNo, const double Resolution);
RTC6_API void __stdcall n_set_mcbsp_matrix_list(const UINT CardNo);
RTC6_API void __stdcall n_set_mcbsp_global_x_list(const UINT CardNo, const double ScaleX);
RTC6_API void __stdcall n_set_mcbsp_global_y_list(const UINT CardNo, const double ScaleY);
RTC6_API void __stdcall n_set_mcbsp_global_rot_list(const UINT CardNo, const double Resolution);
RTC6_API void __stdcall n_set_mcbsp_global_matrix_list(const UINT CardNo);
RTC6_API void __stdcall n_set_mcbsp_in_list(const UINT CardNo, const UINT Mode, const double Scale);
RTC6_API void __stdcall n_set_multi_mcbsp_in_list(const UINT CardNo, const UINT Ctrl, const UINT P, const UINT Mode);
RTC6_API void __stdcall n_wait_for_encoder_mode(const UINT CardNo, const LONG Value, const UINT EncoderNo, const LONG Mode);
RTC6_API void __stdcall n_wait_for_mcbsp(const UINT CardNo, const UINT Axis, const LONG Value, const LONG Mode);
RTC6_API void __stdcall n_set_encoder_speed(const UINT CardNo, const UINT EncoderNo, const double Speed, const double Smooth);
RTC6_API void __stdcall n_get_mcbsp_list(const UINT CardNo);
RTC6_API void __stdcall n_store_encoder(const UINT CardNo, const UINT Pos);
RTC6_API void __stdcall n_wait_for_encoder_in_range_mode(const UINT CardNo, const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax, const UINT Mode);
RTC6_API void __stdcall n_wait_for_encoder_in_range(const UINT CardNo, const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax);
RTC6_API void __stdcall n_activate_fly_xy(const UINT CardNo, const double ScaleX, const double ScaleY);
RTC6_API void __stdcall n_activate_fly_2d(const UINT CardNo, const double ScaleX, const double ScaleY);
RTC6_API void __stdcall n_activate_fly_xy_encoder(const UINT CardNo, const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
RTC6_API void __stdcall n_activate_fly_2d_encoder(const UINT CardNo, const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
RTC6_API void __stdcall n_if_not_activated(const UINT CardNo);
RTC6_API void __stdcall n_park_position(const UINT CardNo, const UINT Mode, const LONG X, const LONG Y);
RTC6_API void __stdcall n_park_return(const UINT CardNo, const UINT Mode, const LONG X, const LONG Y);
RTC6_API void __stdcall n_fly_prediction(const UINT CardNo, UINT PredictionX, UINT PredictionY);
RTC6_API void __stdcall n_set_fly_1_axis(const UINT CardNo, const UINT Axis, const UINT Mode, const double Scale);
RTC6_API void __stdcall n_fly_return_1_axis(const UINT CardNo, const UINT Axis, const LONG RetPos);
RTC6_API void __stdcall n_wait_for_1_axis(const UINT CardNo, LONG Value, const UINT EncoderMode, const LONG WaitMode, const UINT LaserMode);
RTC6_API void __stdcall n_activate_fly_1_axis(const UINT CardNo, const UINT Axis, const UINT Mode, const double Scale, const LONG Offset);
RTC6_API void __stdcall n_park_position_1_axis(const UINT CardNo, const UINT Mode, const UINT Axis, const LONG ParkPos);
RTC6_API void __stdcall n_park_return_1_axis(const UINT CardNo, const UINT Mode, const UINT Axis, const LONG RetPos);
RTC6_API void __stdcall n_set_fly_2_axes(const UINT CardNo, const UINT Axis1, const UINT Mode1, const double Scale1, const UINT Axis2, const UINT Mode2, const double Scale2);
RTC6_API void __stdcall n_fly_return_2_axes(const UINT CardNo, const UINT Axis1, const LONG RetPos1, const UINT Axis2, const LONG RetPos2);
RTC6_API void __stdcall n_wait_for_2_axes(const UINT CardNo, const UINT EncoderModeX, const LONG MinValueX, const LONG MaxValueX, const UINT EncoderModeY, const LONG MinValueY, const LONG MaxValueY, const LONG WaitMode, const UINT LaserMode);
RTC6_API void __stdcall n_activate_fly_2_axes(const UINT CardNo, const UINT ModeX, const double ScaleX, const LONG OffsetX, const UINT ModeY, const double ScaleY, const LONG OffsetY);
RTC6_API void __stdcall n_park_position_2_axes(const UINT CardNo, const UINT Mode, const LONG ParkPosX, const LONG ParkPosY);
RTC6_API void __stdcall n_park_return_2_axes(const UINT CardNo, const UINT Mode, const LONG RetPosX, const LONG RetkPosY);
RTC6_API void __stdcall n_set_fly_3_axes(const UINT CardNo, const UINT ModeX, const double ScaleX, const UINT ModeY, const double ScaleY, const UINT ModeZ, const double ScaleZ);
RTC6_API void __stdcall n_fly_return_3_axes(const UINT CardNo, const LONG RetPosX, const LONG RetPosY, const LONG RetPosZ);
RTC6_API void __stdcall n_init_fly_2d_list(const UINT CardNo, const LONG OffsetX, const LONG OffsetY, const UINT No);
RTC6_API void __stdcall n_fly_disable_list(const UINT CardNo);
RTC6_API void __stdcall n_wait_for_encoder(const UINT CardNo, const LONG Value, const UINT EncoderNo);
RTC6_API void __stdcall fly_return_z(const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall fly_return(const LONG X, const LONG Y);
RTC6_API void __stdcall set_rot_center_list(const LONG X, const LONG Y);
RTC6_API void __stdcall set_ext_start_delay_list(const LONG Delay, const UINT EncoderNo);
RTC6_API void __stdcall set_fly_x(const double ScaleX);
RTC6_API void __stdcall set_fly_y(const double ScaleY);
RTC6_API void __stdcall set_fly_z(const double ScaleZ, const UINT EncoderNo);
RTC6_API void __stdcall set_fly_rot(const double Resolution);
RTC6_API void __stdcall set_fly_2d(const double ScaleX, const double ScaleY);
RTC6_API void __stdcall set_fly_x_pos(const double ScaleX);
RTC6_API void __stdcall set_fly_y_pos(const double ScaleY);
RTC6_API void __stdcall set_fly_rot_pos(const double Resolution);
RTC6_API void __stdcall set_fly_limits(const LONG Xmin, const LONG Xmax, const LONG Ymin, const LONG Ymax);
RTC6_API void __stdcall set_fly_limits_z(const LONG Zmin, const LONG Zmax);
RTC6_API void __stdcall if_fly_x_overflow(const LONG Mode);
RTC6_API void __stdcall if_fly_y_overflow(const LONG Mode);
RTC6_API void __stdcall if_fly_z_overflow(const LONG Mode);
RTC6_API void __stdcall if_not_fly_x_overflow(const LONG Mode);
RTC6_API void __stdcall if_not_fly_y_overflow(const LONG Mode);
RTC6_API void __stdcall if_not_fly_z_overflow(const LONG Mode);
RTC6_API void __stdcall clear_fly_overflow(const UINT Mode);
RTC6_API void __stdcall set_mcbsp_x_list(const double ScaleX);
RTC6_API void __stdcall set_mcbsp_y_list(const double ScaleY);
RTC6_API void __stdcall set_mcbsp_rot_list(const double Resolution);
RTC6_API void __stdcall set_mcbsp_matrix_list(void);
RTC6_API void __stdcall set_mcbsp_global_x_list(const double ScaleX);
RTC6_API void __stdcall set_mcbsp_global_y_list(const double ScaleY);
RTC6_API void __stdcall set_mcbsp_global_rot_list(const double Resolution);
RTC6_API void __stdcall set_mcbsp_global_matrix_list(void);
RTC6_API void __stdcall set_mcbsp_in_list(const UINT Mode, const double Scale);
RTC6_API void __stdcall set_multi_mcbsp_in_list(const UINT Ctrl, const UINT P, const UINT Mode);
RTC6_API void __stdcall wait_for_encoder_mode(const LONG Value, const UINT EncoderNo, const LONG Mode);
RTC6_API void __stdcall wait_for_mcbsp(const UINT Axis, const LONG Value, const LONG Mode);
RTC6_API void __stdcall set_encoder_speed(const UINT EncoderNo, const double Speed, const double Smooth);
RTC6_API void __stdcall get_mcbsp_list(void);
RTC6_API void __stdcall store_encoder(const UINT Pos);
RTC6_API void __stdcall wait_for_encoder_in_range_mode(const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax, const UINT Mode);
RTC6_API void __stdcall wait_for_encoder_in_range(const LONG EncXmin, const LONG EncXmax, const LONG EncYmin, const LONG EncYmax);
RTC6_API void __stdcall activate_fly_xy(const double ScaleX, const double ScaleY);
RTC6_API void __stdcall activate_fly_2d(const double ScaleX, const double ScaleY);
RTC6_API void __stdcall activate_fly_xy_encoder(const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
RTC6_API void __stdcall activate_fly_2d_encoder(const double ScaleX, const double ScaleY, const LONG EncX, const LONG EncY);
RTC6_API void __stdcall if_not_activated(void);
RTC6_API void __stdcall park_position(const UINT Mode, const LONG X, const LONG Y);
RTC6_API void __stdcall park_return(const UINT Mode, const LONG X, const LONG Y);
RTC6_API void __stdcall fly_prediction(UINT PredictionX, UINT PredictionY);
RTC6_API void __stdcall set_fly_1_axis(const UINT Axis, const UINT Mode, const double Scale);
RTC6_API void __stdcall fly_return_1_axis(const UINT Axis, const LONG RetPos);
RTC6_API void __stdcall wait_for_1_axis(const LONG Value, const UINT EncoderMode, const LONG WaitMode, const UINT LaserMode);
RTC6_API void __stdcall activate_fly_1_axis(const UINT Axis, const UINT Mode, const double Scale, const LONG Offset);
RTC6_API void __stdcall park_position_1_axis(const UINT Mode, const UINT Axis, const LONG ParkPos);
RTC6_API void __stdcall park_return_1_axis(const UINT Mode, const UINT Axis, const LONG RetPos);
RTC6_API void __stdcall set_fly_2_axes(const UINT Axis1, const UINT Mode1, const double Scale1, const UINT Axis2, const UINT Mode2, const double Scale2);
RTC6_API void __stdcall fly_return_2_axes(const UINT Axis1, const LONG RetPos1, const UINT Axis2, const LONG RetPos2);
RTC6_API void __stdcall wait_for_2_axes(const UINT EncoderModeX, const LONG MinValueX, const LONG MaxValueX, const UINT EncoderModeY, const LONG MinValueY, const LONG MaxValueY, const LONG WaitMode, const UINT LaserMode);
RTC6_API void __stdcall activate_fly_2_axes(const UINT ModeX, const double ScaleX, const LONG OffsetX, const UINT ModeY, const double ScaleY, const LONG OffsetY);
RTC6_API void __stdcall park_position_2_axes(const UINT Mode, const LONG ParkPosX, const LONG ParkPosY);
RTC6_API void __stdcall park_return_2_axes(const UINT Mode, const LONG RetPosX, const LONG RetPosY);
RTC6_API void __stdcall set_fly_3_axes(const UINT ModeX, const double ScaleX, const UINT ModeY, const double ScaleY, const UINT ModeZ, const double ScaleZ);
RTC6_API void __stdcall fly_return_3_axes(const LONG RetPosX, const LONG RetPosY, const LONG RetPosZ);
RTC6_API void __stdcall init_fly_2d_list(const LONG OffsetX, const LONG OffsetY, const UINT No);
RTC6_API void __stdcall fly_disable_list(void);
RTC6_API void __stdcall wait_for_encoder(const LONG Value, const UINT EncoderNo);
RTC6_API void __stdcall n_save_and_restart_timer(const UINT CardNo);
RTC6_API void __stdcall n_set_wobbel_mode_phase(const UINT CardNo, const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode, const double Phase);
RTC6_API void __stdcall n_set_wobbel_mode(const UINT CardNo, const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode);
RTC6_API void __stdcall n_set_wobbel(const UINT CardNo, const UINT Transversal, const UINT Longitudinal, const double Freq);
RTC6_API void __stdcall n_set_wobbel_direction(const UINT CardNo, const LONG dX, const LONG dY);
RTC6_API void __stdcall n_set_wobbel_control(const UINT CardNo, const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
RTC6_API void __stdcall n_set_wobbel_vector(const UINT CardNo, const double dTrans, const double dLong, const UINT Period, const double dPower);
RTC6_API void __stdcall n_set_wobbel_vector_2(const UINT CardNo, const double dTrans, const double dLong, const UINT Period, const double dPower, const double dPower2, const UINT Ctrl);
RTC6_API void __stdcall n_set_wobbel_offset(const UINT CardNo, const LONG OffsetTrans, const LONG OffsetLong);
RTC6_API void __stdcall n_set_trigger(const UINT CardNo, const UINT Period, const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall n_set_trigger4(const UINT CardNo, const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4);
RTC6_API void __stdcall n_set_trigger8(const UINT CardNo, const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4, const UINT Signal5, const UINT Signal6, const UINT Signal7, const UINT Signal8);
RTC6_API void __stdcall n_set_pixel_line_3d(const UINT CardNo, const UINT Channel, const UINT HalfPeriod, const double dX, const double dY, const double dZ);
RTC6_API void __stdcall n_set_pixel_line(const UINT CardNo, const UINT Channel, const UINT HalfPeriod, const double dX, const double dY);
RTC6_API void __stdcall n_set_n_pixel(const UINT CardNo, const UINT PortOutValue1, const UINT PortOutValue2, const UINT Number);
RTC6_API void __stdcall n_set_pixel(const UINT CardNo, const UINT PortOutValue1, const UINT PortOutValue2);
RTC6_API void __stdcall n_rs232_write_text_list(const UINT CardNo, const char* pData);
RTC6_API void __stdcall n_set_mcbsp_out(const UINT CardNo, const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall n_set_mcbsp_out_oie_list(const UINT CardNo, const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall n_set_mcbsp_out_ptr_list(const UINT CardNo, const UINT Number, const ULONG_PTR SignalPtr);
RTC6_API void __stdcall n_camming(const UINT CardNo, const UINT FirstPos, const UINT NPos, const UINT No, const UINT Ctrl, const double Scale, const UINT Code);
RTC6_API void __stdcall n_periodic_toggle_list(const UINT CardNo, const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
RTC6_API void __stdcall n_micro_vector_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall n_micro_vector_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall n_micro_vector_abs(const UINT CardNo, const LONG X, const LONG Y, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall n_micro_vector_rel(const UINT CardNo, const LONG dX, const LONG dY, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall n_multi_axis_micro_vector_scanner_list(const UINT CardNo, const LONG X0, const LONG Y0, const LONG X1, const LONG Y1, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
RTC6_API void __stdcall n_multi_axis_micro_vector_stage_list(const UINT CardNo, const LONG X, const LONG Y, const double Stage, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
RTC6_API void __stdcall n_micro_vector_set_position(const UINT CardNo, const LONG X0, const LONG X1, const LONG X2, const LONG X3, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall n_multi_axis_flags_list(const UINT CardNo, const UINT Flags);
RTC6_API void __stdcall n_set_free_variable_list(const UINT CardNo, const UINT VarNo, const UINT Value);
RTC6_API void __stdcall n_jump_abs_drill_2(const UINT CardNo, const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall n_jump_rel_drill_2(const UINT CardNo, const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall n_jump_abs_drill(const UINT CardNo, const LONG X, const LONG Y, const UINT DrillTime);
RTC6_API void __stdcall n_jump_rel_drill(const UINT CardNo, const LONG dX, const LONG dY, const UINT DrillTime);
RTC6_API void __stdcall n_jump_abs_drill_3(const UINT CardNo, const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall n_jump_rel_drill_3(const UINT CardNo, const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall save_and_restart_timer(void);
RTC6_API void __stdcall set_wobbel_mode_phase(const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode, const double Phase);
RTC6_API void __stdcall set_wobbel_mode(const UINT Transversal, const UINT Longitudinal, const double Freq, const LONG Mode);
RTC6_API void __stdcall set_wobbel(const UINT Transversal, const UINT Longitudinal, const double Freq);
RTC6_API void __stdcall set_wobbel_direction(const LONG dX, const LONG dY);
RTC6_API void __stdcall set_wobbel_control(const UINT Ctrl, const UINT Value, const UINT MinValue, const UINT MaxValue);
RTC6_API void __stdcall set_wobbel_vector(const double dTrans, const double dLong, const UINT Period, const double dPower);
RTC6_API void __stdcall set_wobbel_vector_2(const double dTrans, const double dLong, const UINT Period, const double dPower, const double dPower2, const UINT Ctrl);
RTC6_API void __stdcall set_wobbel_offset(const LONG OffsetTrans, const LONG OffsetLong);
RTC6_API void __stdcall set_trigger(const UINT Period, const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall set_trigger4(const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4);
RTC6_API void __stdcall set_trigger8(const UINT Period, const UINT Signal1, const UINT Signal2, const UINT Signal3, const UINT Signal4, const UINT Signal5, const UINT Signal6, const UINT Signal7, const UINT Signal8);
RTC6_API void __stdcall set_pixel_line_3d(const UINT Channel, const UINT HalfPeriod, const double dX, const double dY, const double dZ);
RTC6_API void __stdcall set_pixel_line(const UINT Channel, const UINT HalfPeriod, const double dX, const double dY);
RTC6_API void __stdcall set_n_pixel(const UINT PortOutValue1, const UINT PortOutValue2, const UINT Number);
RTC6_API void __stdcall set_pixel(const UINT PortOutValue1, const UINT PortOutValue2);
RTC6_API void __stdcall rs232_write_text_list(const char* pData);
RTC6_API void __stdcall set_mcbsp_out(const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall set_mcbsp_out_oie_list(const UINT Signal1, const UINT Signal2);
RTC6_API void __stdcall set_mcbsp_out_ptr_list(const UINT Number, const ULONG_PTR SignalPtr);
RTC6_API void __stdcall camming(const UINT FirstPos, const UINT NPos, const UINT No, const UINT Ctrl, const double Scale, const UINT Code);
RTC6_API void __stdcall periodic_toggle_list(const UINT Port, const UINT Mask, const UINT P1, const UINT P2, const UINT Count, const UINT Start);
RTC6_API void __stdcall micro_vector_abs_3d(const LONG X, const LONG Y, const LONG Z, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall micro_vector_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall micro_vector_abs(const LONG X, const LONG Y, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall micro_vector_rel(const LONG dX, const LONG dY, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall multi_axis_micro_vector_scanner_list(const LONG X0, const LONG Y0, const LONG X1, const LONG Y1, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
RTC6_API void __stdcall multi_axis_micro_vector_stage_list(const LONG X, const LONG Y, const double Stage, const LONG LasOn, const LONG LasOff, const UINT Power, const UINT Port, const double Velocity, const UINT FrameCount, const UINT WaitForSync);
RTC6_API void __stdcall micro_vector_set_position(const LONG X0, const LONG X1, const LONG X2, const LONG X3, const LONG LasOn, const LONG LasOff);
RTC6_API void __stdcall multi_axis_flags_list(const UINT Flags);
RTC6_API void __stdcall set_free_variable_list(const UINT VarNo, const UINT Value);
RTC6_API void __stdcall jump_abs_drill_2(const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall jump_rel_drill_2(const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall jump_abs_drill(const LONG X, const LONG Y, const UINT DrillTime);
RTC6_API void __stdcall jump_rel_drill(const LONG dX, const LONG dY, const UINT DrillTime);
RTC6_API void __stdcall jump_abs_drill_3(const LONG X, const LONG Y, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall jump_rel_drill_3(const LONG dX, const LONG dY, const UINT DrillTime, const LONG XOff, const LONG YOff);
RTC6_API void __stdcall n_timed_mark_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const double T);
RTC6_API void __stdcall n_timed_mark_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const double T);
RTC6_API void __stdcall n_timed_mark_abs(const UINT CardNo, const LONG X, const LONG Y, const double T);
RTC6_API void __stdcall n_timed_mark_rel(const UINT CardNo, const LONG dX, const LONG dY, const double T);
RTC6_API void __stdcall timed_mark_abs_3d(const LONG X, const LONG Y, const LONG Z, const double T);
RTC6_API void __stdcall timed_mark_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const double T);
RTC6_API void __stdcall timed_mark_abs(const LONG X, const LONG Y, const double T);
RTC6_API void __stdcall timed_mark_rel(const LONG dX, const LONG dY, const double T);
RTC6_API void __stdcall n_mark_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall n_mark_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ);
RTC6_API void __stdcall n_mark_abs(const UINT CardNo, const LONG X, const LONG Y);
RTC6_API void __stdcall n_mark_rel(const UINT CardNo, const LONG dX, const LONG dY);
RTC6_API void __stdcall mark_abs_3d(const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall mark_rel_3d(const LONG dX, const LONG dY, const LONG dZ);
RTC6_API void __stdcall mark_abs(const LONG X, const LONG Y);
RTC6_API void __stdcall mark_rel(const LONG dX, const LONG dY);
RTC6_API void __stdcall n_timed_jump_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const double T);
RTC6_API void __stdcall n_timed_jump_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const double T);
RTC6_API void __stdcall n_timed_jump_abs(const UINT CardNo, const LONG X, const LONG Y, const double T);
RTC6_API void __stdcall n_timed_jump_rel(const UINT CardNo, const LONG dX, const LONG dY, const double T);
RTC6_API void __stdcall timed_jump_abs_3d(const LONG X, const LONG Y, const LONG Z, const double T);
RTC6_API void __stdcall timed_jump_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const double T);
RTC6_API void __stdcall timed_jump_abs(const LONG X, const LONG Y, const double T);
RTC6_API void __stdcall timed_jump_rel(const LONG dX, const LONG dY, const double T);
RTC6_API void __stdcall n_jump_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall n_jump_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ);
RTC6_API void __stdcall n_jump_abs(const UINT CardNo, const LONG X, const LONG Y);
RTC6_API void __stdcall n_jump_rel(const UINT CardNo, const LONG dX, const LONG dY);
RTC6_API void __stdcall jump_abs_3d(const LONG X, const LONG Y, const LONG Z);
RTC6_API void __stdcall jump_rel_3d(const LONG dX, const LONG dY, const LONG dZ);
RTC6_API void __stdcall jump_abs(const LONG X, const LONG Y);
RTC6_API void __stdcall jump_rel(const LONG dX, const LONG dY);
RTC6_API void __stdcall n_para_mark_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P);
RTC6_API void __stdcall n_para_mark_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P);
RTC6_API void __stdcall n_para_mark_abs(const UINT CardNo, const LONG X, const LONG Y, const UINT P);
RTC6_API void __stdcall n_para_mark_rel(const UINT CardNo, const LONG dX, const LONG dY, const UINT P);
RTC6_API void __stdcall para_mark_abs_3d(const LONG X, const LONG Y, const LONG Z, const UINT P);
RTC6_API void __stdcall para_mark_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const UINT P);
RTC6_API void __stdcall para_mark_abs(const LONG X, const LONG Y, const UINT P);
RTC6_API void __stdcall para_mark_rel(const LONG dX, const LONG dY, const UINT P);
RTC6_API void __stdcall n_para_jump_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P);
RTC6_API void __stdcall n_para_jump_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P);
RTC6_API void __stdcall n_para_jump_abs(const UINT CardNo, const LONG X, const LONG Y, const UINT P);
RTC6_API void __stdcall n_para_jump_rel(const UINT CardNo, const LONG dX, const LONG dY, const UINT P);
RTC6_API void __stdcall para_jump_abs_3d(const LONG X, const LONG Y, const LONG Z, const UINT P);
RTC6_API void __stdcall para_jump_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const UINT P);
RTC6_API void __stdcall para_jump_abs(const LONG X, const LONG Y, const UINT P);
RTC6_API void __stdcall para_jump_rel(const LONG dX, const LONG dY, const UINT P);
RTC6_API void __stdcall n_timed_para_mark_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_mark_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_jump_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_jump_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_mark_abs(const UINT CardNo, const LONG X, const LONG Y, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_mark_rel(const UINT CardNo, const LONG dX, const LONG dY, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_jump_abs(const UINT CardNo, const LONG X, const LONG Y, const UINT P, const double T);
RTC6_API void __stdcall n_timed_para_jump_rel(const UINT CardNo, const LONG dX, const LONG dY, const UINT P, const double T);
RTC6_API void __stdcall timed_para_mark_abs_3d(const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
RTC6_API void __stdcall timed_para_mark_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
RTC6_API void __stdcall timed_para_jump_abs_3d(const LONG X, const LONG Y, const LONG Z, const UINT P, const double T);
RTC6_API void __stdcall timed_para_jump_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const UINT P, const double T);
RTC6_API void __stdcall timed_para_mark_abs(const LONG X, const LONG Y, const UINT P, const double T);
RTC6_API void __stdcall timed_para_mark_rel(const LONG dX, const LONG dY, const UINT P, const double T);
RTC6_API void __stdcall timed_para_jump_abs(const LONG X, const LONG Y, const UINT P, const double T);
RTC6_API void __stdcall timed_para_jump_rel(const LONG dX, const LONG dY, const UINT P, const double T);
RTC6_API void __stdcall n_set_defocus_list(const UINT CardNo, const LONG Shift);
RTC6_API void __stdcall n_set_defocus_2_list(const UINT CardNo, const LONG Shift, const UINT Mode);
RTC6_API void __stdcall n_set_defocus_offset_list(const UINT CardNo, const LONG Shift);
RTC6_API void __stdcall n_set_zoom_list(const UINT CardNo, const UINT Zoom);
RTC6_API void __stdcall set_defocus_list(const LONG Shift);
RTC6_API void __stdcall set_defocus_2_list(const LONG Shift, const UINT Mode);
RTC6_API void __stdcall set_defocus_offset_list(const LONG Shift);
RTC6_API void __stdcall set_zoom_list(const UINT Zoom);
RTC6_API void __stdcall n_timed_arc_abs(const UINT CardNo, const LONG X, const LONG Y, const double Angle, const double T);
RTC6_API void __stdcall n_timed_arc_rel(const UINT CardNo, const LONG dX, const LONG dY, const double Angle, const double T);
RTC6_API void __stdcall timed_arc_abs(const LONG X, const LONG Y, const double Angle, const double T);
RTC6_API void __stdcall timed_arc_rel(const LONG dX, const LONG dY, const double Angle, const double T);
RTC6_API void __stdcall n_arc_abs_3d(const UINT CardNo, const LONG X, const LONG Y, const LONG Z, const double Angle);
RTC6_API void __stdcall n_arc_rel_3d(const UINT CardNo, const LONG dX, const LONG dY, const LONG dZ, const double Angle);
RTC6_API void __stdcall n_arc_abs(const UINT CardNo, const LONG X, const LONG Y, const double Angle);
RTC6_API void __stdcall n_arc_rel(const UINT CardNo, const LONG dX, const LONG dY, const double Angle);
RTC6_API void __stdcall n_set_ellipse(const UINT CardNo, const UINT A, const UINT B, const double Phi0, const double Phi);
RTC6_API void __stdcall n_mark_ellipse_abs(const UINT CardNo, const LONG X, const LONG Y, const double Alpha);
RTC6_API void __stdcall n_mark_ellipse_rel(const UINT CardNo, const LONG dX, const LONG dY, const double Alpha);
RTC6_API void __stdcall arc_abs_3d(const LONG X, const LONG Y, const LONG Z, const double Angle);
RTC6_API void __stdcall arc_rel_3d(const LONG dX, const LONG dY, const LONG dZ, const double Angle);
RTC6_API void __stdcall arc_abs(const LONG X, const LONG Y, const double Angle);
RTC6_API void __stdcall arc_rel(const LONG dX, const LONG dY, const double Angle);
RTC6_API void __stdcall set_ellipse(const UINT A, const UINT B, const double Phi0, const double Phi);
RTC6_API void __stdcall mark_ellipse_abs(const LONG X, const LONG Y, const double Alpha);
RTC6_API void __stdcall mark_ellipse_rel(const LONG dX, const LONG dY, const double Alpha);
RTC6_API void __stdcall n_set_offset_xyz_list(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
RTC6_API void __stdcall n_set_offset_list(const UINT CardNo, const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
RTC6_API void __stdcall n_set_matrix_list(const UINT CardNo, const UINT HeadNo, const UINT Ind1, const UINT Ind2, const double Mij, const UINT at_once);
RTC6_API void __stdcall n_set_angle_list(const UINT CardNo, const UINT HeadNo, const double Angle, const UINT at_once);
RTC6_API void __stdcall n_set_scale_list(const UINT CardNo, const UINT HeadNo, const double Scale, const UINT at_once);
RTC6_API void __stdcall n_apply_mcbsp_list(const UINT CardNo, const UINT HeadNo, const UINT at_once);
RTC6_API void __stdcall set_offset_xyz_list(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const LONG ZOffset, const UINT at_once);
RTC6_API void __stdcall set_offset_list(const UINT HeadNo, const LONG XOffset, const LONG YOffset, const UINT at_once);
RTC6_API void __stdcall set_matrix_list(const UINT HeadNo, const UINT Ind1, const UINT Ind2, const double Mij, const UINT at_once);
RTC6_API void __stdcall set_angle_list(const UINT HeadNo, const double Angle, const UINT at_once);
RTC6_API void __stdcall set_scale_list(const UINT HeadNo, const double Scale, const UINT at_once);
RTC6_API void __stdcall apply_mcbsp_list(const UINT HeadNo, const UINT at_once);
RTC6_API void __stdcall n_set_mark_speed(const UINT CardNo, const double Speed);
RTC6_API void __stdcall n_set_jump_speed(const UINT CardNo, const double Speed);
RTC6_API void __stdcall n_set_sky_writing_para_list(const UINT CardNo, const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
RTC6_API void __stdcall n_set_sky_writing_list(const UINT CardNo, const double Timelag, const LONG LaserOnShift);
RTC6_API void __stdcall n_set_sky_writing_limit_list(const UINT CardNo, const double CosAngle);
RTC6_API void __stdcall n_set_sky_writing_mode_list(const UINT CardNo, const UINT Mode);
RTC6_API void __stdcall n_set_scanner_delays(const UINT CardNo, const UINT Jump, const UINT Mark, const UINT Polygon);
RTC6_API void __stdcall n_set_jump_mode_list(const UINT CardNo, const LONG Flag);
RTC6_API void __stdcall n_enduring_wobbel(const UINT CardNo);
RTC6_API void __stdcall n_set_delay_mode_list(const UINT CardNo, const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
RTC6_API void __stdcall n_set_sky_writing_min_speed_list(const UINT CardNo, const double Speed);
RTC6_API void __stdcall n_set_sky_writing_scale_list(const UINT CardNo, const double Scale);
RTC6_API void __stdcall set_mark_speed(const double Speed);
RTC6_API void __stdcall set_jump_speed(const double Speed);
RTC6_API void __stdcall set_sky_writing_para_list(const double Timelag, const LONG LaserOnShift, const UINT Nprev, const UINT Npost);
RTC6_API void __stdcall set_sky_writing_list(const double Timelag, const LONG LaserOnShift);
RTC6_API void __stdcall set_sky_writing_limit_list(const double CosAngle);
RTC6_API void __stdcall set_sky_writing_mode_list(const UINT Mode);
RTC6_API void __stdcall set_scanner_delays(const UINT Jump, const UINT Mark, const UINT Polygon);
RTC6_API void __stdcall set_jump_mode_list(const LONG Flag);
RTC6_API void __stdcall enduring_wobbel(void);
RTC6_API void __stdcall set_delay_mode_list(const UINT VarPoly, const UINT DirectMove3D, const UINT EdgeLevel, const UINT MinJumpDelay, const UINT JumpLengthLimit);
RTC6_API void __stdcall set_sky_writing_min_speed_list(const double Speed);
RTC6_API void __stdcall set_sky_writing_scale_list(const double Scale);
RTC6_API void __stdcall n_activate_scanahead_autodelays_list(const UINT CardNo, const LONG Mode);
RTC6_API void __stdcall n_set_scanahead_laser_shifts_list(const UINT CardNo, const LONG dLasOn, const LONG dLasOff);
RTC6_API void __stdcall n_set_scanahead_line_params_list(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale);
RTC6_API void __stdcall n_set_scanahead_line_params_ex_list(const UINT CardNo, const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
RTC6_API void __stdcall activate_scanahead_autodelays_list(const LONG Mode);
RTC6_API void __stdcall set_scanahead_laser_shifts_list(const LONG dLasOn, const LONG dLasOff);
RTC6_API void __stdcall set_scanahead_line_params_list(const UINT CornerScale, const UINT EndScale, const UINT AccScale);
RTC6_API void __stdcall set_scanahead_line_params_ex_list(const UINT CornerScale, const UINT EndScale, const UINT AccScale, const UINT JumpScale);
RTC6_API void __stdcall n_stepper_enable_list(const UINT CardNo, const LONG Enable1, const LONG Enable2);
RTC6_API void __stdcall n_stepper_control_list(const UINT CardNo, const LONG Period1, const LONG Period2);
RTC6_API void __stdcall n_stepper_abs_no_list(const UINT CardNo, const UINT No, const LONG Pos);
RTC6_API void __stdcall n_stepper_rel_no_list(const UINT CardNo, const UINT No, const LONG dPos);
RTC6_API void __stdcall n_stepper_abs_list(const UINT CardNo, const LONG Pos1, const LONG Pos2);
RTC6_API void __stdcall n_stepper_rel_list(const UINT CardNo, const LONG dPos1, const LONG dPos2);
RTC6_API void __stdcall n_stepper_wait(const UINT CardNo, const UINT No);
RTC6_API void __stdcall stepper_enable_list(const LONG Enable1, const LONG Enable2);
RTC6_API void __stdcall stepper_control_list(const LONG Period1, const LONG Period2);
RTC6_API void __stdcall stepper_abs_no_list(const UINT No, const LONG Pos);
RTC6_API void __stdcall stepper_rel_no_list(const UINT No, const LONG dPos);
RTC6_API void __stdcall stepper_abs_list(const LONG Pos1, const LONG Pos2);
RTC6_API void __stdcall stepper_rel_list(const LONG dPos1, const LONG dPos2);
RTC6_API void __stdcall stepper_wait(const UINT No);
RTC6_API void __stdcall n_set_laser_timing_table(const UINT CardNo, const UINT Index, const UINT F);
RTC6_API void __stdcall n_set_duty_cycle_table(const UINT CardNo, const UINT Index, const UINT DutyCycle);
RTC6_API void __stdcall n_regulation3(const UINT CardNo, const UINT Fmax, const UINT Fmin);
RTC6_API void __stdcall set_laser_timing_table(const UINT Index, const UINT F);
RTC6_API void __stdcall set_duty_cycle_table(const UINT Index, const UINT DutyCycle);
RTC6_API void __stdcall regulation3(const UINT Fmax, const UINT Fmin);

#if defined(__cplusplus)
}      //  extern "C"
#endif //defined(__cplusplus)
